package com.biz.crm.mdm.business.product.local.service.notifier;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.product.level.sdk.event.ProductLevelEventListener;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.local.service.ProductService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 商品层级监听实现
 *
 * @author sunx
 * @date 2021/10/18
 */
@Component
public class ProductLevelEventListenerImpl implements ProductLevelEventListener {

  @Autowired(required = false) private ProductService productService;

  /**
   * 当新增产品层级时通知监听
   *
   * @param productLevelVos
   */
  @Override
  public void onBatchCreate(List<ProductLevelVo> productLevelVos) {
    // 无需实现
  }

  /**
   * 当更新产品层级时通知监听
   *
   * @param productLevelVos
   */
  @Override
  public void onBatchUpdate(List<ProductLevelVo> productLevelVos) {
    // 无需实现
  }

  /**
   * 当删除产品层级时通知监听
   *
   * @param productLevelVos
   */
  @Override
  public void onBatchDelete(List<ProductLevelVo> productLevelVos) {
    Validate.isTrue(CollectionUtils.isNotEmpty(productLevelVos), "触发参数不能为空");
    List<String> productLevelCodes =
        productLevelVos.stream()
            .filter(a -> StringUtils.isNotBlank(a.getProductLevelCode()))
            .map(ProductLevelVo::getProductLevelCode)
            .collect(Collectors.toList());
    Validate.isTrue(CollectionUtils.isNotEmpty(productLevelCodes), "商品层级编码参数不能为空");
    Integer count =
        productService.countByProductLevelCodesAndDelFlag(
            productLevelCodes, DelFlagStatusEnum.NORMAL.getCode());
    count = Optional.ofNullable(count).orElse(0);
    Validate.isTrue(count.compareTo(0) <= 0, "存在对应的商品信息");
  }

  /**
   * 当启用产品层级时通知监听
   *
   * @param productLevelVos
   */
  @Override
  public void onBatchEnable(List<ProductLevelVo> productLevelVos) {
    // 无需实现
  }

  /**
   * 当禁用产品层级时通知监听
   *
   * @param productLevelVos
   */
  @Override
  public void onBatchDisable(List<ProductLevelVo> productLevelVos) {
    // 无需实现
  }
}
