/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDetailQueryDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductPaginationDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\u7ba1\u7406: ProductVo: \u5546\u54c1\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/product/product"})
public class ProductVoController {
    private static final Logger log = LoggerFactory.getLogger(ProductVoController.class);
    @Autowired(required=false)
    private ProductVoService productVoService;

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<ProductVo> findDetailById(@RequestParam(value="id") String id) {
        LinkedList ids = Lists.newLinkedList();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            ids.add(id);
        }
        try {
            ProductVo vo = null;
            List list = this.productVoService.findDetailsByIdsOrProductCodes((List)ids, null);
            Optional optional = list.stream().findFirst();
            if (optional.isPresent()) {
                vo = (ProductVo)optional.get();
            }
            return Result.ok(vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5546\u54c1\u5546\u54c1id\u96c6\u5408\u6216\u7f16\u7801\u96c6\u5408\u83b7\u53d6\u5546\u54c1\u4fe1\u606f")
    @GetMapping(value={"/findDetailsByIdsOrCodes"})
    public Result<List<ProductVo>> findDetailsByIdsOrCodes(@RequestParam(value="ids") List<String> ids, @RequestParam(value="codes") List<String> codes) {
        try {
            List list = this.productVoService.findDetailsByIdsOrProductCodes(ids, codes);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<ProductVo> create(@RequestBody ProductDto dto) {
        try {
            ProductVo current = this.productVoService.create(dto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<ProductVo> update(@RequestBody ProductDto dto) {
        try {
            ProductVo current = this.productVoService.update(dto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5546\u54c1\u5c42\u7ea7\u83b7\u53d6\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f")
    @GetMapping(value={"/findByProductLevelCodes"})
    public Result<List<ProductVo>> findByProductLevelCodes(@RequestParam(value="productLevelCodeList") List<String> productLevelCodeList) {
        try {
            return Result.ok((Object)this.productVoService.findByProductLevelCodes(productLevelCodeList));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5546\u54c1\u5546\u54c1\u7f16\u7801\u96c6\u5408\u83b7\u53d6\u5546\u54c1\u4e3b\u4fe1\u606f+\u5c42\u7ea7\u4fe1\u606f")
    @GetMapping(value={"/findMainDetailsByProductCodes"})
    public Result<List<ProductVo>> findMainDetailsByProductCodes(@RequestParam(value="productCodeList") List<String> productCodeList) {
        try {
            List list = this.productVoService.findMainDetailsByProductCodes(productCodeList);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eProductQueryDto\u83b7\u53d6\u5546\u54c1\u4e3b\u4fe1\u606f")
    @GetMapping(value={"/findByProductQueryDto"})
    public Result<List<ProductVo>> findByProductQueryDto(ProductQueryDto dto) {
        try {
            List list = this.productVoService.findByProductQueryDto(dto);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eProductDetailQueryDto\u83b7\u53d6\u5546\u54c1\u4fe1\u606f")
    @GetMapping(value={"/findDetailsByProductDetailQueryDto"})
    public Result<List<ProductVo>> findDetailsByProductDetailQueryDto(ProductDetailQueryDto dto) {
        try {
            List list = this.productVoService.findDetailsByProductDetailQueryDto(dto);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5c42\u7ea7\u83b7\u53d6\u5c42\u7ea7\u53ca\u4e0b\u7ea7\u6240\u6709\u7684\u4e0a\u67b6\u4e14\u542f\u7528\u7684\u4ea7\u54c1\u96c6\u5408")
    @GetMapping(value={"/findAllowSaleProductByProductLevelCodes"})
    public Result<Map<String, String>> findAllowSaleProductByProductLevelCodes(@RequestParam(value="productLevelCodes") Set<String> productLevelCodes) {
        try {
            Map map = this.productVoService.findAllowSaleProductByProductLevelCodes(productLevelCodes);
            return Result.ok((Object)map);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findPageProductVoByConditions"})
    public Result<Page<ProductVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, ProductPaginationDto paginationDto) {
        try {
            paginationDto = Optional.ofNullable(paginationDto).orElse(new ProductPaginationDto());
            paginationDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            Page result = this.productVoService.findByConditions(pageable, paginationDto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

