/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.product.local.entity.Product;
import com.biz.crm.mdm.business.product.local.mapper.ProductMapper;
import com.biz.crm.mdm.business.product.sdk.dto.ContractProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductPaginationDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.enums.IsShelfEnum;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ProductRepository
extends ServiceImpl<ProductMapper, Product> {
    private static final Integer SIZE = 1000;

    public Page<Product> findByConditions(Page<Product> page, ProductPaginationDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((ProductMapper)this.baseMapper).findByConditions(page, dto);
    }

    public Product findById(String id) {
        return (Product)((Object)((ProductMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public List<Product> findByProductCodes(List<String> productCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(Product::getProductCode, productCodes)).list();
    }

    public List<Product> findByIdsOrProductCodes(List<String> ids, List<String> productCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.in(CollectionUtils.isNotEmpty((Collection)ids), UuidEntity::getId, (Collection)ids)).or()).in(CollectionUtils.isNotEmpty((Collection)productCodes), Product::getProductCode, (Collection)productCodes);
        })).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void updateIsShelfByIds(List<String> ids, String code) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(Product::getIsShelf, (Object)code)).update();
    }

    public void updateIsShelfByByProductCodes(List<String> productCodeList, String code) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(Product::getProductCode, productCodeList)).set(Product::getIsShelf, (Object)code)).update();
    }

    public Integer countByProductLevelCodesAndDelFlag(List<String> productLevelCodes, String delFlag) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotBlank((CharSequence)delFlag), UuidFlagOpEntity::getDelFlag, (Object)delFlag)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(CollectionUtils.isNotEmpty(productLevelCodes), Product::getProductLevelCode, productLevelCodes)).count();
    }

    public List<ProductVo> findByProductLevelCodes(List<String> productLevelCodeList) {
        return ((ProductMapper)this.baseMapper).findByProductLevelCodes(productLevelCodeList, TenantUtils.getTenantCode(), DelFlagStatusEnum.NORMAL.getCode());
    }

    public Set<String> findProductLevelCodeSetByProductCodes(Set<String> productCodeSet) {
        return ((ProductMapper)this.baseMapper).findProductLevelCodeSetByProductCodes(productCodeSet, TenantUtils.getTenantCode());
    }

    public Product findByProductCode(String code, String delFlag) {
        return (Product)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Product::getProductCode, (Object)code)).eq(UuidFlagOpEntity::getDelFlag, (Object)delFlag)).one());
    }

    public List<Product> findByProductQueryDto(ProductQueryDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<Object> list = Lists.newLinkedList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getProductCodeList())) {
            for (List item : Lists.partition((List)Lists.newArrayList((Iterable)dto.getProductCodeList()), (int)SIZE)) {
                dto.setProductCodeList(item);
                List<Product> cur = ((ProductMapper)this.baseMapper).findByProductQueryDto(dto);
                if (!CollectionUtils.isNotEmpty(cur)) continue;
                list.addAll(cur);
            }
        } else {
            list = ((ProductMapper)this.baseMapper).findByProductQueryDto(dto);
        }
        return list;
    }

    public List<Product> findByContractProductQueryDto(ContractProductQueryDto dto) {
        String tenantCode = TenantUtils.getTenantCode();
        String delFlag = DelFlagStatusEnum.NORMAL.getCode();
        String enableStatus = EnableStatusEnum.ENABLE.getCode();
        String shelfFlag = IsShelfEnum.UP.getCode();
        return ((ProductMapper)this.baseMapper).findByContractProductQueryDto(dto, tenantCode, delFlag, enableStatus, shelfFlag);
    }
}

