/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.product.level.sdk.dto.RelateProductLevelCodeQueryDto;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.local.entity.Product;
import com.biz.crm.mdm.business.product.local.repository.ProductRepository;
import com.biz.crm.mdm.business.product.local.service.ProductService;
import com.biz.crm.mdm.business.product.sdk.dto.ContractProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductEventDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductPaginationDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductSingleEventDto;
import com.biz.crm.mdm.business.product.sdk.enums.IsShelfEnum;
import com.biz.crm.mdm.business.product.sdk.event.ProductEventListener;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="productService")
public class ProductServiceImpl
implements ProductService {
    @Autowired(required=false)
    private ProductRepository productRepository;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public Page<Product> findByConditions(Pageable pageable, ProductPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new ProductPaginationDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<Product> pageResult = this.productRepository.findByConditions((Page<Product>)page, dto);
        List<Object> productLevelCodes = Lists.newLinkedList();
        Map<Object, Object> productLevelMap = Maps.newHashMap();
        List productLevelVos = Lists.newLinkedList();
        Boolean flag = pageResult != null && CollectionUtils.isNotEmpty((Collection)pageResult.getRecords());
        if (Boolean.TRUE.equals(flag)) {
            productLevelCodes = pageResult.getRecords().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductLevelCode())).map(Product::getProductLevelCode).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty((Collection)productLevelCodes)) {
            productLevelVos = this.productLevelVoSdkService.findListByCodes((List)productLevelCodes);
        }
        if (CollectionUtils.isNotEmpty((Collection)productLevelVos)) {
            productLevelMap = productLevelVos.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductLevelCode()) && StringUtils.isNotBlank((CharSequence)a.getProductLevelName())).collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, ProductLevelVo::getProductLevelName, (a, b) -> a));
        }
        if (Boolean.TRUE.equals(flag)) {
            for (Product item : pageResult.getRecords()) {
                item.setProductLevelName(productLevelMap.getOrDefault(item.getProductLevelCode(), ""));
            }
        }
        return pageResult;
    }

    @Override
    public List<Product> findDetailsByIdsOrProductCodes(List<String> ids, List<String> productCodes) {
        if (CollectionUtils.isEmpty(ids) && CollectionUtils.isEmpty(productCodes)) {
            return Lists.newLinkedList();
        }
        return this.productRepository.findByIdsOrProductCodes(ids, productCodes);
    }

    @Override
    @Transactional
    public Product create(Product product) {
        this.createValidation(product);
        product.setId(null);
        product.setTenantCode(TenantUtils.getTenantCode());
        product.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        product.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.productRepository.saveOrUpdate((Object)product);
        return product;
    }

    @Override
    @Transactional
    public Product update(Product product) {
        this.updateValidation(product);
        String currentId = product.getId();
        Product current = this.productRepository.findById(currentId);
        Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)product.getProductCode().equals(current.getProductCode()), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        this.productRepository.saveOrUpdate((Object)product);
        return product;
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List list = this.productVoService.findDetailsByIdsOrProductCodes(ids, null);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        this.productRepository.updateDelFlagByIds(ids);
        ProductEventDto productEventDto = new ProductEventDto();
        for (ProductVo productVo : list) {
            productEventDto.setOriginal(productVo);
            productEventDto.setNewest(null);
            SerializableBiConsumer & Serializable onDelete = ProductEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)productEventDto, ProductEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Override
    @Transactional
    public void upShelf(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productRepository.updateIsShelfByIds(ids, IsShelfEnum.UP.getCode());
        List list = this.productVoService.findDetailsByIdsOrProductCodes(ids, null);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (ProductVo productVo : list) {
            ProductSingleEventDto productSingleEventDto = new ProductSingleEventDto();
            productSingleEventDto.setId(productVo.getId());
            JSONObject object1 = new JSONObject();
            object1.put("isShelf", (Object)IsShelfEnum.DOWN.getCode());
            object1.put("enableStatus", (Object)productVo.getEnableStatus());
            object1.put("productCode", (Object)productVo.getProductCode());
            object1.put("productLevelCode", (Object)productVo.getProductLevelCode());
            JSONObject object2 = new JSONObject();
            object2.put("isShelf", (Object)IsShelfEnum.UP.getCode());
            object2.put("enableStatus", (Object)productVo.getEnableStatus());
            object2.put("productCode", (Object)productVo.getProductCode());
            object2.put("productLevelCode", (Object)productVo.getProductLevelCode());
            productSingleEventDto.setOriginal((Object)object1);
            productSingleEventDto.setNewest((Object)object2);
            SerializableBiConsumer & Serializable onUpShelf = ProductEventListener::onUpShelf;
            this.nebulaNetEventClient.publish((NebulaEventDto)productSingleEventDto, ProductEventListener.class, (SerializableBiConsumer)onUpShelf);
        }
    }

    @Override
    @Transactional
    public void downShelf(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productRepository.updateIsShelfByIds(ids, IsShelfEnum.DOWN.getCode());
        List list = this.productVoService.findDetailsByIdsOrProductCodes(ids, null);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (ProductVo productVo : list) {
            ProductSingleEventDto productSingleEventDto = new ProductSingleEventDto();
            productSingleEventDto.setId(productVo.getId());
            JSONObject object1 = new JSONObject();
            object1.put("isShelf", (Object)IsShelfEnum.UP.getCode());
            object1.put("enableStatus", (Object)productVo.getEnableStatus());
            object1.put("productCode", (Object)productVo.getProductCode());
            object1.put("productLevelCode", (Object)productVo.getProductLevelCode());
            JSONObject object2 = new JSONObject();
            object2.put("isShelf", (Object)IsShelfEnum.DOWN.getCode());
            object2.put("enableStatus", (Object)productVo.getEnableStatus());
            object2.put("productCode", (Object)productVo.getProductCode());
            object2.put("productLevelCode", (Object)productVo.getProductLevelCode());
            productSingleEventDto.setOriginal((Object)object1);
            productSingleEventDto.setNewest((Object)object2);
            SerializableBiConsumer & Serializable onDownShelf = ProductEventListener::onDownShelf;
            this.nebulaNetEventClient.publish((NebulaEventDto)productSingleEventDto, ProductEventListener.class, (SerializableBiConsumer)onDownShelf);
        }
    }

    @Override
    @Transactional
    public void upShelfByProductCodes(List<String> productCodeList) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(productCodeList), (String)"productCode\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productRepository.updateIsShelfByByProductCodes(productCodeList, IsShelfEnum.UP.getCode());
        List list = this.productVoService.findDetailsByIdsOrProductCodes(null, productCodeList);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (ProductVo productVo : list) {
            ProductSingleEventDto productSingleEventDto = new ProductSingleEventDto();
            productSingleEventDto.setId(productVo.getId());
            JSONObject object1 = new JSONObject();
            object1.put("isShelf", (Object)IsShelfEnum.DOWN.getCode());
            object1.put("enableStatus", (Object)productVo.getEnableStatus());
            object1.put("productCode", (Object)productVo.getProductCode());
            object1.put("productLevelCode", (Object)productVo.getProductLevelCode());
            JSONObject object2 = new JSONObject();
            object2.put("isShelf", (Object)IsShelfEnum.UP.getCode());
            object2.put("enableStatus", (Object)productVo.getEnableStatus());
            object2.put("productCode", (Object)productVo.getProductCode());
            object2.put("productLevelCode", (Object)productVo.getProductLevelCode());
            productSingleEventDto.setOriginal((Object)object1);
            productSingleEventDto.setNewest((Object)object2);
            SerializableBiConsumer & Serializable onUpShelf = ProductEventListener::onUpShelf;
            this.nebulaNetEventClient.publish((NebulaEventDto)productSingleEventDto, ProductEventListener.class, (SerializableBiConsumer)onUpShelf);
        }
    }

    @Override
    @Transactional
    public void downShelfByProductCodes(List<String> productCodeList) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(productCodeList), (String)"productCode\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productRepository.updateIsShelfByByProductCodes(productCodeList, IsShelfEnum.DOWN.getCode());
        List list = this.productVoService.findDetailsByIdsOrProductCodes(null, productCodeList);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (ProductVo productVo : list) {
            ProductSingleEventDto productSingleEventDto = new ProductSingleEventDto();
            productSingleEventDto.setId(productVo.getId());
            JSONObject object1 = new JSONObject();
            object1.put("isShelf", (Object)IsShelfEnum.UP.getCode());
            object1.put("enableStatus", (Object)productVo.getEnableStatus());
            object1.put("productCode", (Object)productVo.getProductCode());
            object1.put("productLevelCode", (Object)productVo.getProductLevelCode());
            JSONObject object2 = new JSONObject();
            object2.put("isShelf", (Object)IsShelfEnum.DOWN.getCode());
            object2.put("enableStatus", (Object)productVo.getEnableStatus());
            object2.put("productCode", (Object)productVo.getProductCode());
            object2.put("productLevelCode", (Object)productVo.getProductLevelCode());
            productSingleEventDto.setOriginal((Object)object1);
            productSingleEventDto.setNewest((Object)object2);
            SerializableBiConsumer & Serializable onDownShelf = ProductEventListener::onDownShelf;
            this.nebulaNetEventClient.publish((NebulaEventDto)productSingleEventDto, ProductEventListener.class, (SerializableBiConsumer)onDownShelf);
        }
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        List list = this.productVoService.findDetailsByIdsOrProductCodes(ids, null);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (ProductVo productVo : list) {
            ProductSingleEventDto productSingleEventDto = new ProductSingleEventDto();
            productSingleEventDto.setId(productVo.getId());
            JSONObject object1 = new JSONObject();
            object1.put("isShelf", (Object)productVo.getIsShelf());
            object1.put("enableStatus", (Object)EnableStatusEnum.DISABLE.getCode());
            object1.put("productCode", (Object)productVo.getProductCode());
            object1.put("productLevelCode", (Object)productVo.getProductLevelCode());
            JSONObject object2 = new JSONObject();
            object2.put("isShelf", (Object)productVo.getIsShelf());
            object2.put("enableStatus", (Object)EnableStatusEnum.ENABLE.getCode());
            object2.put("productCode", (Object)productVo.getProductCode());
            object2.put("productLevelCode", (Object)productVo.getProductLevelCode());
            productSingleEventDto.setOriginal((Object)object1);
            productSingleEventDto.setNewest((Object)object2);
            SerializableBiConsumer & Serializable onEnable = ProductEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)productSingleEventDto, ProductEventListener.class, (SerializableBiConsumer)onEnable);
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        List list = this.productVoService.findDetailsByIdsOrProductCodes(ids, null);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (ProductVo productVo : list) {
            ProductSingleEventDto productSingleEventDto = new ProductSingleEventDto();
            productSingleEventDto.setId(productVo.getId());
            JSONObject object1 = new JSONObject();
            object1.put("isShelf", (Object)productVo.getIsShelf());
            object1.put("enableStatus", (Object)EnableStatusEnum.ENABLE.getCode());
            object1.put("productCode", (Object)productVo.getProductCode());
            object1.put("productLevelCode", (Object)productVo.getProductLevelCode());
            JSONObject object2 = new JSONObject();
            object2.put("isShelf", (Object)productVo.getIsShelf());
            object2.put("enableStatus", (Object)EnableStatusEnum.DISABLE.getCode());
            object2.put("productCode", (Object)productVo.getProductCode());
            object2.put("productLevelCode", (Object)productVo.getProductLevelCode());
            productSingleEventDto.setOriginal((Object)object1);
            productSingleEventDto.setNewest((Object)object2);
            SerializableBiConsumer & Serializable onDisable = ProductEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)productSingleEventDto, ProductEventListener.class, (SerializableBiConsumer)onDisable);
        }
    }

    @Override
    public Integer countByProductLevelCodesAndDelFlag(List<String> productLevelCodes, String delFlag) {
        if (CollectionUtils.isEmpty(productLevelCodes) || StringUtils.isBlank((CharSequence)delFlag)) {
            return 0;
        }
        return this.productRepository.countByProductLevelCodesAndDelFlag(productLevelCodes, delFlag);
    }

    @Override
    public Set<String> findProductLevelCodeSetByProductCodes(Set<String> productCodeSet) {
        if (CollectionUtils.isEmpty(productCodeSet)) {
            return Sets.newHashSet();
        }
        return this.productRepository.findProductLevelCodeSetByProductCodes(productCodeSet);
    }

    @Override
    public Product findByProductCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.productRepository.findByProductCode(code, DelFlagStatusEnum.NORMAL.getCode());
    }

    @Override
    public List<Product> findByContractProductQueryDto(ContractProductQueryDto dto) {
        if (Objects.isNull(dto) || CollectionUtils.isEmpty((Collection)dto.getProductCodeSet()) && CollectionUtils.isEmpty((Collection)dto.getProductLevelCodeSet())) {
            return Lists.newLinkedList();
        }
        HashSet levelCodeSet = Sets.newHashSet();
        if (!CollectionUtils.isEmpty((Collection)dto.getProductLevelCodeSet())) {
            RelateProductLevelCodeQueryDto queryDto = new RelateProductLevelCodeQueryDto();
            queryDto.setSearchType(Integer.valueOf(-1));
            queryDto.setProductLevelCodeSet(dto.getProductLevelCodeSet());
            Map mapLevel = this.productLevelVoSdkService.findByRelateProductLevelCodeQueryDto(queryDto);
            if (!mapLevel.isEmpty()) {
                levelCodeSet.addAll(mapLevel.keySet());
            }
        }
        dto.setProductLevelCodeSet((Set)levelCodeSet);
        dto.setUnionType(Boolean.FALSE);
        if (!CollectionUtils.isEmpty((Collection)dto.getProductCodeSet()) && !CollectionUtils.isEmpty((Collection)dto.getProductLevelCodeSet())) {
            dto.setUnionType(Boolean.TRUE);
        }
        return this.productRepository.findByContractProductQueryDto(dto);
    }

    private void createValidation(Product product) {
        this.validation(product);
    }

    private void updateValidation(Product product) {
        Validate.notNull((Object)((Object)product), (String)"\u5546\u54c1\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)product.getId()), (String)"\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validation(product);
    }

    private void validation(Product product) {
        Validate.notNull((Object)((Object)product), (String)"\u5546\u54c1\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)product.getProductCode()), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)product.getProductType()), (String)"\u5546\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)product.getProductName()), (String)"\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)product.getIsShelf()), (String)"\u4e0a\u4e0b\u67b6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)product.getBeginDateTime(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)product.getEndDateTime(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

