/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.biz.crm.mdm.business.product.level.sdk.dto.RelateProductLevelCodeQueryDto;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.local.entity.Product;
import com.biz.crm.mdm.business.product.local.entity.ProductIntroduction;
import com.biz.crm.mdm.business.product.local.entity.ProductMaterial;
import com.biz.crm.mdm.business.product.local.entity.ProductMedia;
import com.biz.crm.mdm.business.product.local.repository.ProductRepository;
import com.biz.crm.mdm.business.product.local.service.ProductIntroductionService;
import com.biz.crm.mdm.business.product.local.service.ProductMaterialService;
import com.biz.crm.mdm.business.product.local.service.ProductMediaService;
import com.biz.crm.mdm.business.product.local.service.ProductService;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDetailQueryDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductEventDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductMaterialDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductMediaDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductPaginationDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.enums.IsShelfEnum;
import com.biz.crm.mdm.business.product.sdk.enums.MediaTypeEnum;
import com.biz.crm.mdm.business.product.sdk.enums.ProductExtInfoTypeEnum;
import com.biz.crm.mdm.business.product.sdk.event.ProductEventListener;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.MaterialProductVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductIntroductionVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductMaterialVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductMediaVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="productVoService")
public class ProductVoServiceImpl
implements ProductVoService {
    @Autowired(required=false)
    private ProductService productService;
    @Autowired(required=false)
    private ProductMaterialService productMaterialService;
    @Autowired(required=false)
    private ProductMediaService productMediaService;
    @Autowired(required=false)
    private ProductIntroductionService productIntroductionService;
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required=false)
    private MaterialVoService materialVoService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private ProductRepository productRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Transactional
    public ProductVo create(ProductDto dto) {
        this.createValidation(dto);
        Product product = this.buildProductByDto(dto);
        dto.setProductCode(product.getProductCode());
        this.bindProductExtInfo(dto);
        this.productService.create(product);
        ProductEventDto productEventDto = new ProductEventDto();
        productEventDto.setOriginal(null);
        ProductVo productVo = (ProductVo)this.nebulaToolkitService.copyObjectByBlankList((Object)product, ProductVo.class, HashSet.class, LinkedList.class, new String[0]);
        productEventDto.setNewest(productVo);
        SerializableBiConsumer & Serializable onCreate = ProductEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)productEventDto, ProductEventListener.class, (SerializableBiConsumer)onCreate);
        return this.buildByDtoAndProduct(dto, product);
    }

    @Transactional
    public ProductVo update(ProductDto dto) {
        this.updateValidation(dto);
        List<ProductVo> current = this.findDetailsByIdsOrProductCodes(null, Collections.singletonList(dto.getProductCode()));
        ProductVo current2 = current.stream().findFirst().orElse(null);
        Validate.notNull((Object)current2, (String)"\u672a\u83b7\u53d6\u5230\u4fee\u6539\u7684\u5546\u54c1\u4fe1\u606f", (Object[])new Object[0]);
        ProductVo productVo = (ProductVo)this.nebulaToolkitService.copyObjectByBlankList((Object)current2, ProductVo.class, HashSet.class, LinkedList.class, new String[0]);
        Product product = this.buildProductByDto(dto);
        this.bindProductExtInfo(dto);
        this.productService.update(product);
        ProductEventDto productEventDto = new ProductEventDto();
        productEventDto.setOriginal(productVo);
        ProductVo productVo2 = (ProductVo)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, ProductVo.class, HashSet.class, LinkedList.class, new String[0]);
        productEventDto.setNewest(productVo2);
        SerializableBiConsumer & Serializable onUpdate = ProductEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)productEventDto, ProductEventListener.class, (SerializableBiConsumer)onUpdate);
        return this.buildByDtoAndProduct(dto, product);
    }

    public List<ProductVo> findSelectByKeyword(String keyword) {
        PageRequest pageable = PageRequest.of((int)0, (int)20);
        ProductPaginationDto dto = new ProductPaginationDto();
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setKeyword(keyword);
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<Product> pageResult = this.productRepository.findByConditions((Page<Product>)page, dto);
        if (Objects.isNull(pageResult) || CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return Lists.newLinkedList();
        }
        ArrayList list = Lists.newArrayList();
        for (Product item : pageResult.getRecords()) {
            ProductVo cur = new ProductVo();
            cur.setProductCode(item.getProductCode());
            cur.setProductName(item.getProductName());
            list.add(cur);
        }
        return list;
    }

    public MaterialProductVo findMaterialProductVoByMaterialCode(String materialCode) {
        if (StringUtils.isBlank((CharSequence)materialCode)) {
            return null;
        }
        Set<String> productCodeSet = this.productMaterialService.findProductCodeByMaterialCode(materialCode);
        if (CollectionUtils.isEmpty(productCodeSet)) {
            return null;
        }
        MaterialProductVo re = new MaterialProductVo();
        re.setProductCodeSet(productCodeSet);
        Set<String> productParentLevelCodeSet = this.findParentLevelCodeSetByProductCodes(productCodeSet);
        re.setProductLevelCodeSet(productParentLevelCodeSet);
        return re;
    }

    public List<ProductVo> findByProductLevelCodes(List<String> productLevelCodeList) {
        if (CollectionUtils.isEmpty(productLevelCodeList)) {
            return Lists.newLinkedList();
        }
        return this.productRepository.findByProductLevelCodes(productLevelCodeList);
    }

    public Set<String> findParentLevelCodeSetByProductCodes(Set<String> productCodeSet) {
        if (CollectionUtils.isEmpty(productCodeSet)) {
            return Sets.newHashSet();
        }
        Set<String> productLevelCodeSet = this.productService.findProductLevelCodeSetByProductCodes(productCodeSet);
        if (CollectionUtils.isEmpty(productLevelCodeSet)) {
            return Sets.newHashSet();
        }
        Map map = this.productLevelVoSdkService.findCurAndParentByCodes((List)Lists.newArrayList(productLevelCodeSet));
        if (map.isEmpty()) {
            return Sets.newHashSet();
        }
        HashSet re = Sets.newHashSet();
        for (Map.Entry item : map.entrySet()) {
            for (ProductLevelVo sub : (List)item.getValue()) {
                re.add(sub.getProductLevelCode());
            }
        }
        return re;
    }

    public List<ProductVo> findByProductQueryDto(ProductQueryDto dto) {
        Boolean f = Objects.isNull(dto) || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{dto.getProductCode(), dto.getProductName(), dto.getProductName(), dto.getIsShelf(), dto.getEnableStatus()}) && CollectionUtils.isEmpty((Collection)dto.getProductLevelCodeList()) && CollectionUtils.isEmpty((Collection)dto.getProductCodeList());
        if (Boolean.TRUE.equals(f)) {
            return Lists.newLinkedList();
        }
        List<Product> list = this.productRepository.findByProductQueryDto(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(list, Product.class, ProductVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<ProductVo> findDetailsByIdsOrProductCodes(List<String> ids, List<String> productCodes) {
        if (CollectionUtils.isEmpty(ids) && CollectionUtils.isEmpty(productCodes)) {
            return Lists.newLinkedList();
        }
        ProductDetailQueryDto dto = new ProductDetailQueryDto();
        dto.setExInfoCodes(ProductExtInfoTypeEnum.findAllKey());
        if (CollectionUtils.isNotEmpty(ids)) {
            dto.setCodeQueryFlag(Boolean.valueOf(false));
            dto.setCodes(ids);
        } else if (CollectionUtils.isNotEmpty(productCodes)) {
            dto.setCodeQueryFlag(Boolean.valueOf(true));
            dto.setCodes(productCodes);
        }
        return this.findDetailsByProductDetailQueryDto(dto);
    }

    public List<ProductVo> findMainDetailsByProductCodes(List<String> productCodeList) {
        if (CollectionUtils.isEmpty(productCodeList)) {
            return Lists.newLinkedList();
        }
        ProductDetailQueryDto dto = new ProductDetailQueryDto();
        dto.setExInfoCodes((Set)Sets.newHashSet((Object[])new String[]{ProductExtInfoTypeEnum.PRODUCT_LEVEL.getDictCode()}));
        dto.setCodeQueryFlag(Boolean.valueOf(true));
        dto.setCodes(productCodeList);
        return this.findDetailsByProductDetailQueryDto(dto);
    }

    public List<ProductVo> findDetailsByProductDetailQueryDto(ProductDetailQueryDto dto) {
        if (Objects.isNull(dto) || CollectionUtils.isEmpty((Collection)dto.getCodes())) {
            return Lists.newLinkedList();
        }
        List ids = Lists.newLinkedList();
        List productCodes = Lists.newLinkedList();
        if (Boolean.TRUE.equals(dto.getCodeQueryFlag())) {
            productCodes = dto.getCodes();
        } else {
            ids = dto.getCodes();
        }
        List<Product> productList = this.productService.findDetailsByIdsOrProductCodes(ids, productCodes);
        if (CollectionUtils.isEmpty(productList)) {
            return Lists.newLinkedList();
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList(productList, Product.class, ProductVo.class, HashSet.class, ArrayList.class, new String[0]);
        Set<String> productCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductCode())).map(ProductVo::getProductCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty((Collection)dto.getExInfoCodes()) || CollectionUtils.isEmpty(productCodeSet)) {
            return list;
        }
        if (dto.getExInfoCodes().contains(ProductExtInfoTypeEnum.PRODUCT_LEVEL.getDictCode())) {
            this.findProductLevelInfo(list);
        }
        if (dto.getExInfoCodes().contains(ProductExtInfoTypeEnum.MATERIAL.getDictCode())) {
            this.findProductMaterialInfo(list, productCodeSet);
        }
        if (dto.getExInfoCodes().contains(ProductExtInfoTypeEnum.PICTURE.getDictCode()) || dto.getExInfoCodes().contains(ProductExtInfoTypeEnum.VIDEO.getDictCode())) {
            this.findProductMediaInfo(list, productCodeSet);
        }
        if (dto.getExInfoCodes().contains(ProductExtInfoTypeEnum.INTRO.getDictCode())) {
            this.findProductIntroInfo(list, productCodeSet);
        }
        return list;
    }

    public Map<String, String> findAllowSaleProductByProductLevelCodes(Set<String> productLevelCodes) {
        if (CollectionUtils.isEmpty(productLevelCodes)) {
            return Maps.newHashMap();
        }
        RelateProductLevelCodeQueryDto queryDto = new RelateProductLevelCodeQueryDto();
        queryDto.setProductLevelCodeSet(productLevelCodes);
        queryDto.setSearchType(Integer.valueOf(-1));
        Map productLevelRuleMap = this.productLevelVoSdkService.findByRelateProductLevelCodeQueryDto(queryDto);
        if (productLevelRuleMap.isEmpty()) {
            return Maps.newHashMap();
        }
        ProductQueryDto productQueryDto = new ProductQueryDto();
        productQueryDto.setProductLevelCodeList((List)Lists.newArrayList(productLevelCodes));
        productQueryDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        productQueryDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        productQueryDto.setIsShelf(IsShelfEnum.UP.getCode());
        productQueryDto.setTenantCode(TenantUtils.getTenantCode());
        List<ProductVo> list = this.findByProductQueryDto(productQueryDto);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Map<String, String> map = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getProductCode(), a.getProductLevelCode()}) && productLevelRuleMap.keySet().contains(a.getProductLevelCode())).collect(Collectors.toMap(ProductVo::getProductCode, ProductVo::getProductLevelCode, (a, b) -> a));
        HashMap re = Maps.newHashMap();
        for (Map.Entry<String, String> item : map.entrySet()) {
            String s = (String)productLevelRuleMap.get(item.getValue());
            if (StringUtils.isBlank((CharSequence)s)) continue;
            re.put(item.getKey(), s);
        }
        return re;
    }

    public Page<ProductVo> findByConditions(Pageable pageable, ProductPaginationDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<Product> pageResult = this.productRepository.findByConditions((Page<Product>)page, dto);
        Page productVoPage = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return productVoPage;
        }
        List productVos = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)pageResult.getRecords(), Product.class, ProductVo.class, HashSet.class, ArrayList.class, new String[0]);
        productVoPage.setRecords(productVos);
        return productVoPage;
    }

    private void bindProductExtInfo(ProductDto dto) {
        Validate.notNull((Object)dto, (String)"\u5546\u54c1\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        List productMaterialList = Lists.newLinkedList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getMaterialList())) {
            productMaterialList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getMaterialList(), ProductMaterialDto.class, ProductMaterial.class, HashSet.class, ArrayList.class, new String[0]);
            productMaterialList.forEach(a -> a.setProductCode(dto.getProductCode()));
        }
        this.productMaterialService.saveBatch(productMaterialList, dto.getProductCode());
        LinkedList productMediaList = Lists.newLinkedList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getPictureMediaList())) {
            productMediaList.addAll(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getPictureMediaList(), ProductMediaDto.class, ProductMedia.class, HashSet.class, ArrayList.class, new String[0]));
            productMediaList.forEach(a -> a.setProductCode(dto.getProductCode()));
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getVideoMediaList())) {
            productMediaList.addAll(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getVideoMediaList(), ProductMediaDto.class, ProductMedia.class, HashSet.class, ArrayList.class, new String[0]));
            productMediaList.forEach(a -> a.setProductCode(dto.getProductCode()));
        }
        this.productMediaService.saveBatch(productMediaList, dto.getProductCode());
        ProductIntroduction productIntroduction = null;
        if (Objects.nonNull(dto.getIntroduction())) {
            productIntroduction = (ProductIntroduction)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto.getIntroduction(), ProductIntroduction.class, HashSet.class, ArrayList.class, new String[0]));
            productIntroduction.setProductCode(dto.getProductCode());
        }
        this.productIntroductionService.saveIntroduction(productIntroduction, dto.getProductCode());
    }

    private Product buildProductByDto(ProductDto dto) {
        Product product = (Product)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, Product.class, HashSet.class, ArrayList.class, new String[0]));
        product.setMaintenancePicture(CollectionUtils.isNotEmpty((Collection)dto.getPictureMediaList()));
        product.setMaintenanceIntroduction(Objects.nonNull(dto.getIntroduction()));
        if (StringUtils.isBlank((CharSequence)product.getProductCode())) {
            String productCode = (String)this.generateCodeService.generateCode("SPBM", 1).get(0);
            product.setProductCode(productCode);
        }
        if (CollectionUtils.isEmpty((Collection)dto.getPictureMediaList())) {
            return product;
        }
        Optional first = dto.getPictureMediaList().stream().findFirst();
        if (first.isPresent()) {
            product.setPrimaryPictureUrl(((ProductMediaDto)first.get()).getUrlAddress());
        }
        return product;
    }

    private ProductVo buildByDtoAndProduct(ProductDto dto, Product product) {
        ProductVo vo = (ProductVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)product, ProductVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)dto.getMaterialList())) {
            vo.setMaterialList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getMaterialList(), ProductMaterialDto.class, ProductMaterialVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getPictureMediaList())) {
            vo.setPictureMediaList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getVideoMediaList(), ProductMediaDto.class, ProductMediaVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getVideoMediaList())) {
            vo.setVideoMediaList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getVideoMediaList(), ProductMediaDto.class, ProductMediaVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (Objects.nonNull(dto.getIntroduction())) {
            vo.setIntroduction((ProductIntroductionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto.getIntroduction(), ProductIntroductionVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        return vo;
    }

    private void findProductLevelInfo(List<ProductVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Set productLevelCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductLevelCode())).map(ProductVo::getProductLevelCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(productLevelCodeSet)) {
            return;
        }
        List productLevelVoList = this.productLevelVoSdkService.findListByCodes((List)Lists.newArrayList(productLevelCodeSet));
        Map<String, String> mapLevel = productLevelVoList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getProductLevelCode(), a.getProductLevelName()})).collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, ProductLevelVo::getProductLevelName, (a, b) -> a));
        for (ProductVo item : list) {
            item.setProductLevelName(mapLevel.get(item.getProductLevelCode()));
        }
    }

    private void findProductMaterialInfo(List<ProductVo> list, Set<String> productCodeSet) {
        if (CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(productCodeSet)) {
            return;
        }
        List<ProductMaterial> materialList = this.productMaterialService.findByProductCodes(Lists.newArrayList(productCodeSet));
        if (CollectionUtils.isEmpty(materialList)) {
            return;
        }
        Set materialCodes = materialList.stream().map(ProductMaterial::getMaterialCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(materialCodes)) {
            return;
        }
        List materialVoList = this.materialVoService.findDetailByMaterialCodes(materialCodes);
        if (CollectionUtils.isEmpty((Collection)materialVoList)) {
            return;
        }
        Map map = materialVoList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getMaterialCode())).collect(Collectors.toMap(MaterialVo::getMaterialCode, Function.identity(), (a, b) -> a));
        List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(materialList, ProductMaterial.class, ProductMaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (ProductMaterialVo v : voList) {
            if (!map.containsKey(v.getMaterialCode())) continue;
            MaterialVo materialVo = (MaterialVo)map.get(v.getMaterialCode());
            v.setProductLevelCode(materialVo.getProductLevelCode());
            v.setProductLevelName(materialVo.getProductLevelName());
            v.setMaterialType(materialVo.getMaterialType());
            v.setMaterialTypeName(materialVo.getMaterialTypeName());
            v.setUnitTypeCode(materialVo.getUnitTypeCode());
        }
        Map<String, List<ProductMaterialVo>> mapProductMaterial = voList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductCode())).collect(Collectors.groupingBy(ProductMaterialVo::getProductCode));
        for (ProductVo item : list) {
            item.setMaterialList(mapProductMaterial.get(item.getProductCode()));
        }
    }

    private void findProductMediaInfo(List<ProductVo> list, Set<String> productCodeSet) {
        if (CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(productCodeSet)) {
            return;
        }
        List<ProductMedia> mediaList = this.productMediaService.findByProductCodes(Lists.newArrayList(productCodeSet));
        if (CollectionUtils.isEmpty(mediaList)) {
            return;
        }
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(mediaList, ProductMedia.class, ProductMediaVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, List<ProductMediaVo>> map = voList.stream().collect(Collectors.groupingBy(ProductMediaVo::getType));
        Map<String, List<ProductMediaVo>> mapPictureMedia = map.getOrDefault(MediaTypeEnum.PICTURE.getCode(), Lists.newArrayList()).stream().collect(Collectors.groupingBy(ProductMediaVo::getProductCode));
        Map<String, List<ProductMediaVo>> mapVideoMedia = map.getOrDefault(MediaTypeEnum.VIDEO.getCode(), Lists.newArrayList()).stream().collect(Collectors.groupingBy(ProductMediaVo::getProductCode));
        for (ProductVo item : list) {
            item.setPictureMediaList(mapPictureMedia.get(item.getProductCode()));
            item.setVideoMediaList(mapVideoMedia.get(item.getProductCode()));
        }
    }

    private void findProductIntroInfo(List<ProductVo> list, Set<String> productCodeSet) {
        if (CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(productCodeSet)) {
            return;
        }
        List<ProductIntroduction> introductionList = this.productIntroductionService.findByProductCodes(Lists.newArrayList(productCodeSet));
        if (CollectionUtils.isEmpty(introductionList)) {
            return;
        }
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(introductionList, ProductIntroduction.class, ProductIntroductionVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map map = voList.stream().collect(Collectors.toMap(ProductIntroductionVo::getProductCode, Function.identity(), (a, b) -> a));
        for (ProductVo item : list) {
            item.setIntroduction((ProductIntroductionVo)map.get(item.getProductCode()));
        }
    }

    private void createValidation(ProductDto dto) {
        this.validation(dto);
    }

    private void updateValidation(ProductDto dto) {
        Validate.notNull((Object)dto, (String)"\u5546\u54c1\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getId()), (String)"\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validation(dto);
    }

    private void validation(ProductDto dto) {
        Validate.notNull((Object)dto, (String)"\u5546\u54c1\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)dto.getProductCode())) {
            Product byProductCode = this.productService.findByProductCode(dto.getProductCode());
            Validate.isTrue((Objects.isNull((Object)byProductCode) || (StringUtils.isNotBlank((CharSequence)dto.getId()) ? dto.getId().equals(byProductCode.getId()) : Objects.isNull((Object)byProductCode)) ? 1 : 0) != 0, (String)"\u5546\u54c1\u7f16\u7801\u91cd\u590d", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)dto.getProductType(), (String)"\u5546\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProductName(), (String)"\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getIsShelf(), (String)"\u4e0a\u4e0b\u67b6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getBeginDateTime(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEndDateTime(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getMaterialList()), (String)"\u7269\u6599\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

