package com.biz.crm.mdm.business.product.local.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.local.service.ProductService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductPlanningDetailsVo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

/**
 * 产品策划通过产品编码查询商品数据(ProductPlanningDetailsVo)
 *
 * @author pengxi
 * @date 2022-09-16 22:30:37
 */
@Slf4j
@Api(tags = "产品策划通过产品编码查询商品数据: ProductPlanningDetailsVo: 产品策划通过产品编码查询商品数据")
@RestController
@RequestMapping(value = {"/v1/productPlanningDetails/productPlanningDetails"})
public class ProductPlanningDetailsController {

    @Autowired(required = false)
    ProductService productService;

    /**
     * 根据商品编码集合获取对应的商品数据信息
     *
     * @param productCode 商品编码集合
     */
    @ApiOperation(value = "根据商品编码集合获取对应的商品数据")
    @GetMapping(value = {"/findByProductPlanning"})
    public Result<ProductPlanningDetailsVo> findByProductPlanningDetails(@RequestParam("productCode") String productCode,
                                                                         @RequestParam(name = "priceType", required = false) String priceType,
                                                                         @RequestParam(name = "customerCode", required = false) String customerCode,
                                                                         @RequestParam(name = "businessModel", required = false) String businessModel,
                                                                         @RequestParam("startDate") String startDate) {
        try {
            ProductPlanningDetailsVo result = this.productService.findByProductPlanningDetails(productCode, customerCode, businessModel, startDate);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
