package com.biz.crm.mdm.business.product.local.controller;



import com.biz.crm.mdm.business.product.local.entity.ProductUnit;
import com.biz.crm.mdm.business.product.local.service.ProductUnitService;
import com.biz.crm.business.common.sdk.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;


import java.util.List;

/**
 * 商品单位(ProductUnit)表相关的http接口
 *
 * @author makejava
 * @since 2023-03-01 11:03:45
 */
@RestController
@RequestMapping("/v1/productUnit/productUnit")
@Slf4j
@Api(tags = "商品单位：ProductUnit：商品单位")
public class ProductUnitController {
  /**
  * 服务对象
  */
  @Autowired
  private ProductUnitService productUnitService;
  
  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
  */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<ProductUnit> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      ProductUnit productUnit = this.productUnitService.findById(id);
      return Result.ok(productUnit);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 新增数据
   *
   * @param productUnit 实体对象
   * @return 新增结果
  */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<ProductUnit> create(@ApiParam(name = "productUnit", value = "商品单位") @RequestBody ProductUnit productUnit) {
    try {
      ProductUnit result = this.productUnitService.create(productUnit);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 修改数据
   *
   * @param productUnit 实体对象
   * @return 修改结果
  */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<ProductUnit> update(@ApiParam(name = "productUnit", value = "商品单位") @RequestBody ProductUnit productUnit) {
    try {
      ProductUnit result = this.productUnitService.update(productUnit);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
}
