package com.biz.crm.mdm.business.product.local.entity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import javax.persistence.*;

import org.springframework.format.annotation.DateTimeFormat;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商品主表实体
 * 1
 *
 * @author sunx
 * @date 2021/10/12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_product")
@Api(tags = "商品主表实体")
@Table(
    name = "mdm_product",
    indexes = {
      @Index(name = "mdm_product_index1", columnList = "tenant_code,product_code", unique = true),
      @Index(name = "mdm_product_index2", columnList = "product_level_code")
    })
@org.hibernate.annotations.Table(appliesTo = "mdm_product", comment = "商品主表")
public class Product extends TenantFlagOpEntity {
  private static final long serialVersionUID = 2274980263975908479L;

  @ApiModelProperty("商品编码")
  @TableField(value = "product_code")
  @Column(name = "product_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商品编码'")
  private String productCode;

  @ApiModelProperty("商品名称")
  @TableField(value = "product_name")
  @Column(name = "product_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '商品名称'")
  private String productName;

  @ApiModelProperty("商品简称")
  @TableField(value = "product_short_name")
  @Column(name = "product_short_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '商品简称'")
  private String productShortName;

  @ApiModelProperty("商品组")
  @TableField(value = "product_org")
  @Column(name = "product_org", length = 64, columnDefinition = "VARCHAR(128) COMMENT '商品组'")
  private String productOrg;

  @ApiModelProperty("商品组描述")
  @TableField(value = "product_org_desc")
  @Column(name = "product_org_desc", length = 64, columnDefinition = "VARCHAR(128) COMMENT '商品组描述'")
  private String productOrgDesc;

  @ApiModelProperty("商品组入数")
  @TableField(value = "product_incoming")
  @Column(name = "product_incoming", length = 64, columnDefinition = "VARCHAR(128) COMMENT '商品组入数'")
  private String productIncoming;


  @ApiModelProperty("重量单位")
  @TableField(value = "unit_weight")
  @Column(name = "unit_weight", length = 64, columnDefinition = "VARCHAR(64) COMMENT '重量单位'")
  private String unitWeight;

  @ApiModelProperty("体积单位")
  @TableField(value = "volume_weight")
  @Column(name = "volume_weight", length = 64, columnDefinition = "VARCHAR(64) COMMENT '体积单位'")
  private String volumeWeight;

  @ApiModelProperty("小包装容量")
  @TableField(value = "package_quantity_min")
  @Column(name = "package_quantity_min", length = 64, columnDefinition = "VARCHAR(64) COMMENT '小包装容量'")
  private String packageQuantityMin;

  @ApiModelProperty("小包装容量单位")
  @TableField(value = "package_quantity_min_unite")
  @Column(name = "package_quantity_min_unite", length = 64, columnDefinition = "VARCHAR(64) COMMENT '小包装容量单位'")
  private String packageQuantityMinUnite;

  @ApiModelProperty("产品品牌编码")
  @TableField(value = "product_brand_code")
  @Column(name = "product_brand_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 产品品牌编码 '")
  private String productBrandCode;

  @ApiModelProperty("产品品牌名称")
  @TableField(value = "product_brand_name")
  @Column(name = "product_brand_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT ' 产品品牌名称 '")
  private String productBrandName;

  @ApiModelProperty("产品品类编码")
  @Column(name = "product_category_code", nullable = true, length = 32, columnDefinition = "varchar(64) COMMENT '产品品类编码'")
  private String productCategoryCode;

  @ApiModelProperty("产品品类名称")
  @Column(name = "product_category_name", nullable = true, length = 256, columnDefinition = "varchar(256) COMMENT '产品品类名称'")
  private String productCategoryName;

  @ApiModelProperty("产品层级编码（品相编码）")
  @TableField(value = "product_level_code")
  @Column(name = "product_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(64) COMMENT ' 产品层级编码（品相编码） '")
  private String productLevelCode;

  @ApiModelProperty("产品层级名称（品相名称）")
  @TableField(value = "product_level_name")
  @Column(name = "product_level_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT ' 产品层级名称（品相名称） '")
  private String productLevelName;

  @ApiModelProperty("商品类型")
  @TableField(value = "product_type")
  @Column(name = "product_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商品类型'")
  private String productType;

  @ApiModelProperty("销售单位")
  @TableField(value = "sale_unit")
  @Column(name = "sale_unit", length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售单位'")
  private String saleUnit;

  @ApiModelProperty("规格")
  @TableField(value = "spec")
  @Column(name = "spec", length = 64, columnDefinition = "VARCHAR(64) COMMENT '规格'")
  private String spec;

  @ApiModelProperty("包装物料")
  @TableField(value = "package_product")
  @Column(name = "package_product", length = 64, columnDefinition = "VARCHAR(64) COMMENT '包装物料'")
  private String packageProduct;

  @ApiModelProperty("包装描述")
  @TableField(value = "package_desc")
  @Column(name = "package_desc", length = 64, columnDefinition = "VARCHAR(64) COMMENT '包装描述'")
  private String packageDesc;

  @ApiModelProperty("财务管理报告品牌")
  @TableField(value = "package_report")
  @Column(name = "package_report", length = 64, columnDefinition = "VARCHAR(64) COMMENT '财务管理报告品牌'")
  private String packageReport;

  @ApiModelProperty("财务管理报告品牌描述")
  @TableField(value = "package_report_desc")
  @Column(name = "package_report_desc", length = 255, columnDefinition = "VARCHAR(64) COMMENT '财务管理报告品牌描述'")
  private String packageReportDescDesc;

  @ApiModelProperty("产品真实属性")
  @TableField(value = "package_true_props")
  @Column(name = "package_true_props", length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品真实属性'")
  private String packageTrueProps;

  @ApiModelProperty("纸箱条码(外包)")
  @TableField(value = "carton_bar_code")
  @Column(name = "carton_bar_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '纸箱条码(外包)'")
  private String cartonBarCode;

  @ApiModelProperty("长")
  @TableField(value = "forte")
  @Column(name = "forte", length = 64, columnDefinition = "VARCHAR(64) COMMENT '长'")
  private String forte;

  @ApiModelProperty("宽")
  @TableField(value = "width")
  @Column(name = "width", length = 64, columnDefinition = "VARCHAR(64) COMMENT '宽'")
  private String width;

  @ApiModelProperty("高")
  @TableField(value = "high")
  @Column(name = "high", length = 64, columnDefinition = "VARCHAR(64) COMMENT '高'")
  private String high;


  @ApiModelProperty("包装系数")
  @TableField(value = "package_scale")
  @Column(name = "package_scale", length = 64, columnDefinition = "VARCHAR(64) COMMENT '包装系数'")
  private String packageScale;

  @ApiModelProperty("液态产品密度")
  @TableField(value = "liquid_state_product_density")
  @Column(name = "liquid_state_product_density", length = 64, columnDefinition = "VARCHAR(64) COMMENT '液态产品密度'")
  private String liquidStateProductDensity;

  @ApiModelProperty("业务量")
  @TableField(value = "business_amount")
  @Column(name = "business_amount", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务量'")
  private String businessAmount;

  @ApiModelProperty("口味")
  @TableField(value = "taste")
  @Column(name = "taste", length = 64, columnDefinition = "VARCHAR(64) COMMENT '口味'")
  private String taste;
  /**
   * 净重
   */
  @TableField(value = "net_weight")
  @Column(name = "net_weight", length = 24, columnDefinition = "decimal(24,6) COMMENT '净重'")
  private BigDecimal netWeight;

  @ApiModelProperty("基本单位")
  @TableField(value = "base_unit")
  @Column(name = "base_unit", length = 64, columnDefinition = "VARCHAR(64) COMMENT '基本单位'")
  private String baseUnit;

  @ApiModelProperty("基本单位描述")
  @TableField(value = "base_unit_desc")
  @Column(name = "base_unit_desc", length = 255, columnDefinition = "VARCHAR(255) COMMENT '基本单位描述'")
  private String baseUnitDes;

  @ApiModelProperty("保质期")
  @Column(name = "expiration_date", nullable = true, length = 0, columnDefinition = "integer(0) COMMENT '保质期'")
  private Integer expirationDate;

  @ApiModelProperty("税码")
  @Column(name = "tax_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '税码'")
  private String taxCode;

  @ApiModelProperty("税率")
  @Column(name = "rate", nullable = true, length = 10, columnDefinition = "decimal(10,6) COMMENT '税率'")
  private BigDecimal rate;

  @ApiModelProperty(name = "业态编码", notes = "")
  @Column(name = "", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
  private String businessFormatCode;

  @ApiModelProperty(name = "业态名称", notes = "")
  @Column(name = "business_format_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
  private String businessFormatName;

  @ApiModelProperty("所属销售机构编码")
  @Column(name = "sales_institution_Code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
  private String salesInstitutionCode;

  @ApiModelProperty("所属销售机构")
  @Column(name = "sales_institution_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '所属销售机构'")
  private String salesInstitutionName;

  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("开始时间")
  @TableField(value = "begin_date_time")
  @Column(name = "begin_date_time", columnDefinition = "datetime COMMENT '开始时间'")
  private Date beginDateTime;

  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("结束时间")
  @TableField(value = "end_date_time")
  @Column(name = "end_date_time", columnDefinition = "datetime COMMENT '结束时间'")
  private Date endDateTime;

  @ApiModelProperty("上下架状态")
  @TableField(value = "is_shelf")
  @Column(name = "is_shelf", length = 64, columnDefinition = "VARCHAR(64) COMMENT '上下架状态'")
  private String isShelf;

  @ApiModelProperty("条形码")
  @TableField(value = "bar_code")
  @Column(name = "bar_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '条形码'")
  private String barCode;

  @ApiModelProperty("是否维护图片")
  @TableField(value = "maintenance_picture")
  @Column(name = "maintenance_picture", columnDefinition = "int COMMENT '是否维护图片'")
  private Boolean maintenancePicture;

  @ApiModelProperty("是否维护详情")
  @TableField(value = "maintenance_introduction")
  @Column(name = "maintenance_introduction", columnDefinition = "int COMMENT '是否维护详情'")
  private Boolean maintenanceIntroduction;

  @ApiModelProperty("销售公司")
  @TableField(value = "sale_company")
  @Column(name = "sale_company", length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售公司'")
  private String saleCompany;

  @ApiModelProperty("sfa图片地址")
  @TableField(value = "pic_url")
  @Column(name = "pic_url", length = 255, columnDefinition = "VARCHAR(255) COMMENT 'sfa图片地址'")
  private String picUrl;

  @ApiModelProperty("品牌组")
  @TableField(value = "brand_org")
  @Column(name = "brand_org", length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品组'")
  private String brandOrg;

  @ApiModelProperty("行业领域")
  @TableField(value = "biz_field")
  @Column(name = "biz_field", length = 64, columnDefinition = "VARCHAR(64) COMMENT '行业领域'")
  private String bizField;

  @ApiModelProperty("助记码")
  @TableField(value = "mnemonic_mark")
  @Column(name = "mnemonic_mark", length = 64, columnDefinition = "VARCHAR(64) COMMENT '助记码'")
  private String mnemonicMark;


  @ApiModelProperty("数据来源")
  @TableField(value = "source")
  @Column(name = "source", length = 64, columnDefinition = "VARCHAR(64) default '0' COMMENT '数据来源'")
  private String source;

  @ApiModelProperty(name = "电商品类[数据字典:mdm_category]", notes = "")
  @Column(name = "online_category", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '电商品类[数据字典:mdm_category] '")
  private String onlineCategory;

  @ApiModelProperty(name = "主体分类[数据字典:mdm_zhuti_classify]", notes = "")
  @Column(name = "main_category", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '主体分类[数据字典:mdm_zhuti_classify] '")
  private String mainCategory;

  @ApiModelProperty("主图片url")
  @TableField(value = "primary_picture_url")
  @Column(
      name = "primary_picture_url",
      length = 255,
      columnDefinition = "VARCHAR(255) COMMENT '主图片url'")
  private String primaryPictureUrl;

  /**
   * 商品介绍
   */
  @TableField(exist = false)
  @Transient
  private ProductIntroduction introduction;

  /**
   * 物料信息
   */
  @TableField(exist = false)
  @Transient
  private List<ProductMaterial> materialList;

  /**
   * 单位
   */
  @TableField(exist = false)
  @Transient
  private List<ProductUnit> unitList;

  /**
   * 视频图片
   */
  @TableField(exist = false)
  @Transient
  private List<ProductMedia> mediaList;

}
