package com.biz.crm.mdm.business.product.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商品图片视频实体
 *
 * @author sunx
 * @date 2021/10/12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_product_media")
@ApiModel(value = "ProductMedia", description = "商品图片视频")
@Table(
    name = "mdm_product_media",
    indexes = {
      @Index(name = "mdm_product_media_index1", columnList = "tenant_code"),
      @Index(name = "mdm_product_media_index2", columnList = "product_code"),
      @Index(name = "mdm_product_media_index3", columnList = "type")
    })
@org.hibernate.annotations.Table(appliesTo = "mdm_product_media", comment = "商品图片视频表")
public class ProductMedia extends FileEntity {
  private static final long serialVersionUID = -725190354592590536L;

  @ApiModelProperty("商品编码")
  @TableField(value = "product_code")
  @Column(name = "product_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商品编码'")
  private String productCode;

  @ApiModelProperty("文件类型('picture'图片,'video'视频)")
  @TableField(value = "type")
  @Column(
      name = "type",
      length = 32,
      columnDefinition = "VARCHAR(32) COMMENT '文件类型(picture-图片,video-视频)'")
  private String type;
}
