package com.biz.crm.mdm.business.product.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 商品单位实体
 *
 * @author sunx
 * @date 2021/10/12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_product_unit")
@Api(tags = "商品富单位实体")
@Table(name = "mdm_product_unit")
@org.hibernate.annotations.Table(appliesTo = "mdm_product_unit", comment = "商品单位")
public class ProductUnit extends TenantEntity {

  private static final long serialVersionUID = 7189979990642130393L;

  @ApiModelProperty("商品编码")
  @TableField(value = "product_code")
  @Column(name = "product_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商品编码'")
  private String productCode;

  @ApiModelProperty("单位类型,数据字典[product_unit_type]")
  @TableField(value = "unit_type")
  @Column(name = "unit_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '单位类型'")
  private String unitType;

  @ApiModelProperty("单位编码")
  @TableField(value = "unit_code")
  @Column(name = "unit_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '单位编码'")
  private String unitCode;

  @ApiModelProperty("单位名称")
  @TableField(value = "unit_name")
  @Column(name = "unit_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '单位名称'")
  private String unitName;

  @ApiModelProperty("转换系数,基本单位为1")
  @TableField(value = "trans_scale")
  @Column(name = "trans_scale", length = 64, columnDefinition = "VARCHAR(64) COMMENT '转换系数,基本单位为1'")
  private Integer transScale;

  @ApiModelProperty("单位级别")
  @TableField(value = "unit_level")
  @Column(name = "unit_level", length = 64, columnDefinition = "VARCHAR(64) COMMENT '单位级别'")
  private String unitLevel;

  @ApiModelProperty("条形码")
  @TableField(value = "bar_code")
  @Column(name = "bar_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '条形码'")
  private String Barcode;

  @ApiModelProperty("建议销售价")
  @TableField(value = "recommended_sales_price")
  @Column(name = "recommended_sales_price", length = 64, columnDefinition = "VARCHAR(64) COMMENT '建议销售价'")
  private String recommendedSalesPrice;

  @ApiModelProperty("建议进货价")
  @TableField(value = "recommended_restocking_price")
  @Column(name = "recommended_restocking_price", length = 64, columnDefinition = "VARCHAR(64) COMMENT '建议进货价'")
  private String recommendedRestockingPrice;
}
