package com.biz.crm.mdm.business.product.local.repository;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.product.local.entity.ProductIntroduction;
import com.biz.crm.mdm.business.product.local.mapper.ProductIntroductionMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

/**
 * 商品富文本(repository)
 *
 * @author sunx
 * @since 2021-10-14 16:06:25
 */
@Component
public class ProductIntroductionRepository
    extends ServiceImpl<ProductIntroductionMapper, ProductIntroduction> {

  /**
   * 查看商品介绍信息
   * @param productCodeList
   * @return
   */
  public List<ProductIntroduction> findByProductCodes(List<String> productCodeList) {
    return lambdaQuery()
        .eq(ProductIntroduction::getTenantCode, TenantUtils.getTenantCode())
        .in(ProductIntroduction::getProductCode, productCodeList)
        .list();
  }

  public void deleteByProductCode(String productCode) {
    LambdaQueryWrapper<ProductIntroduction> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery
        .eq(ProductIntroduction::getTenantCode, TenantUtils.getTenantCode())
        .eq(ProductIntroduction::getProductCode, productCode);
    baseMapper.delete(lambdaQuery);
  }

  public void deleteBatchcollectProductIntroduction(List<String> collectProductCode) {
    if (CollectionUtils.isEmpty(collectProductCode)) {
      return;
    }
    List<String> listId = new ArrayList<>();
    List<ProductIntroduction> listProductCode= this.lambdaQuery()
            .eq(ProductIntroduction::getTenantCode,TenantUtils.getTenantCode())
            .in(ProductIntroduction::getProductCode, collectProductCode)
            .list();
    if (!ObjectUtils.isEmpty(listProductCode) ) {
      for (ProductIntroduction productIntroduction   : listProductCode) {
        String unitId = productIntroduction.getId();
        listId.add(unitId);
      }
      this.removeByIds(listId);
    }
  }
}
