package com.biz.crm.mdm.business.product.local.service;

import java.util.List;

import com.biz.crm.mdm.business.product.local.entity.ProductIntroduction;

/**
 * 商品富文本介绍信息
 *
 * @author sunx
 * @date 2021/10/12
 */
public interface ProductIntroductionService {

  /**
   * 获取对应商品编码的介绍信息
   *
   * @param productCodeList
   * @return
   */
  List<ProductIntroduction> findByProductCodes(List<String> productCodeList);
  /**
   * 保存商品介绍信息
   * @param productIntroduction
   * @param productCode
   */
  void saveIntroduction(ProductIntroduction productIntroduction, String productCode);

  /**
   * 查看商品介绍信息
   * @param codeList
   * @return
   */
  List<ProductIntroduction> findAllListByCodeList(List<String> codeList);

  /**
   * 保存或者更新
   * @param saveProductIntroductionList
   * @param updateProductIntroductionList
   */
  void saveOrUpdateBatch(List<ProductIntroduction> saveProductIntroductionList, List<ProductIntroduction> updateProductIntroductionList);
}
