package com.biz.crm.mdm.business.product.local.service;

import com.biz.crm.mdm.business.product.local.entity.ProductMedia;
import java.util.List;

/**
 * 商品媒体信息
 *
 * @author sunx
 * @date 2021/10/12
 */
public interface ProductMediaService {

  /**
   * 根据商品编码集合获取对应的媒体信息
   *
   * @param productCodeList
   * @return
   */
  List<ProductMedia> findByProductCodes(List<String> productCodeList);

  /**
   * 保存商品的图片视频信息
   *
   * @param productMediaList
   * @param productCode
   */
  void saveBatch(List<ProductMedia> productMediaList, String productCode);
}
