package com.biz.crm.mdm.business.product.local.service;


import com.biz.crm.mdm.business.product.local.entity.ProductMedia;
import com.biz.crm.mdm.business.product.local.entity.ProductUnit;

import java.util.ArrayList;
import java.util.List;

/**
 * 商品单位(ProductUnit)表服务接口
 *
 * @author makejava
 * @since 2023-03-01 11:03:45
 */
public interface ProductUnitService {

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  ProductUnit findById(String id);

  /**
   * 新增数据
   *
   * @param productUnit 实体对象
   * @return 新增结果
   */
  ProductUnit create(ProductUnit productUnit);

  /**
   * 批量新增
   *
   * @param productUnits 实体对象
   *
   */
  void saveBatch(List<ProductUnit> productUnits);

  /**
   * 修改新据
   *
   * @param productUnit 实体对象
   * @return 修改结果
   */
  ProductUnit update(ProductUnit productUnit);

  List<ProductUnit> findByProductCodes(ArrayList<String> newArrayList);

}

