package com.biz.crm.mdm.business.product.local.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.product.local.service.ProductService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 产品自动更新定时任务     job
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.15 13:39
 */
@Slf4j
@Service
public class ProductAutoSyncXxlJob {


    @Autowired(required = false)
    private ProductService productService;

    /**
     * 产品自动更新定时任务 每天4点自动执行
     */
    @DynamicTaskService(cornExpression = "0 0 3 * * ?", taskDesc = "产品自动更新定时任务")
    public void autoSyncXxlJob() {
        //TODO  需要改成  定时任务分片+redis锁
        log.info("=====>    产品同步[{}] start    <=====", DateUtil.dateStrNowAll());
        MasterDataMdgBaseDto baseDto = new MasterDataMdgBaseDto();
        baseDto.setFullPullFlag(BooleanEnum.TRUE.getCapital());
        productService.pullMaterialList(baseDto);
        log.info("=====>    产品同步[{}] end    <=====", DateUtil.dateStrNowAll());

    }

}
