package com.biz.crm.mdm.business.product.local.service.internal;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.mdm.business.product.local.entity.ProductMedia;
import com.biz.crm.mdm.business.product.local.repository.ProductUnitRepository;
import com.biz.crm.mdm.business.product.local.entity.ProductUnit;
import com.biz.crm.mdm.business.product.local.service.ProductUnitService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;

import javax.swing.undo.CannotRedoException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 商品单位(ProductUnit)表服务实现类
 *
 * @author makejava
 * @since 2023-03-01 11:03:45
 */
@Slf4j
@Service("productUnitService")
public class ProductUnitServiceImpl implements ProductUnitService {

  @Autowired
  private ProductUnitRepository productUnitRepository;

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public ProductUnit findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.productUnitRepository.getById(id);
  }

  /**
   * 新增数据
   *
   * @param productUnit 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public ProductUnit create(ProductUnit productUnit) {
    this.createValidate(productUnit);
    this.productUnitRepository.saveOrUpdate(productUnit);
    return productUnit;
  }

  @Override
  public void saveBatch(List<ProductUnit> productUnits) {
    if (CollectionUtils.isEmpty(productUnits)) {
      return;
    }
    List<String> productCodes = productUnits
            .stream().map(ProductUnit::getProductCode).collect(Collectors.toList());
    LambdaQueryWrapper<ProductUnit> lq = Wrappers.lambdaQuery();
    productUnitRepository.
            remove(lq.in(ProductUnit::getProductCode,productCodes));
    productUnitRepository.saveBatch(productUnits);

  }

  /**
   * 修改新据
   *
   * @param productUnit 实体对象
   * @return 修改结果
   */
  @Transactional
  @Override
  public ProductUnit update(ProductUnit productUnit) {
    this.updateValidate(productUnit);
    this.productUnitRepository.saveOrUpdate(productUnit);
    return productUnit;
  }

  @Override
  public List<ProductUnit> findByProductCodes(ArrayList<String> newArrayList) {
    return productUnitRepository.lambdaQuery().in(ProductUnit::getProductCode, newArrayList).list();
  }


  /**
   * 创建验证
   *
   * @param productUnit
   */
  private void createValidate(ProductUnit productUnit) {
    Validate.notNull(productUnit, "新增时，对象信息不能为空！");
    productUnit.setId(null);
    Validate.notBlank(productUnit.getTenantCode(), "新增数据时，租户编号不能为空！");
    ProductUnit one = productUnitRepository.lambdaQuery()
            .eq(ProductUnit::getProductCode, productUnit.getProductCode())
            .eq(ProductUnit::getUnitCode, productUnit.getProductCode()).one();
    Validate.isTrue(ObjectUtils.isEmpty(one), "对应单位已存在");
  }

  /**
   * 修改验证
   *
   * @param productUnit
   */
  private void updateValidate(ProductUnit productUnit) {
    Validate.notNull(productUnit, "修改时，对象信息不能为空！");
    Validate.notBlank(productUnit.getId(), "修改数据时，不能为空！");
    Validate.notBlank(productUnit.getTenantCode(), "修改数据时，租户编号不能为空！");

  }
}

