package com.biz.crm.mdm.business.product.local.strategy;

import com.biz.crm.mdm.business.product.sdk.dto.DisplayProductDto;
import com.biz.crm.mdm.business.product.sdk.vo.DisplayProductVo;
import java.util.List;

/**
 * @author Kevin
 * @title DisplayProductStrategy
 * @date 2023/3/13 20:03
 * @description 产品关联陈列活动的策略接口
 */
public interface DisplayProductStrategy {

  /**
   * 根据品牌组查询品类名称
   *
   * @param displayProductDto
   * @return
   */
  List<DisplayProductVo> findCategoryName(DisplayProductDto displayProductDto);

  /**
   * 根据品牌组查询物料包装物料
   *
   * @param displayProductDto
   * @return
   */
  List<DisplayProductVo> findPackageDesc(DisplayProductDto displayProductDto);


  /**
   * 根据品类名称查询品牌组
   *
   * @param displayProductDto
   * @return
   */
  List<DisplayProductVo> findBrandOrg(DisplayProductDto displayProductDto);

}
