/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.local.entity.Product;
import com.biz.crm.mdm.business.product.local.service.ProductService;
import com.biz.crm.mdm.business.product.sdk.dto.ContractProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductPaginationDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\u7ba1\u7406: Product: \u5546\u54c1\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/product/product"})
public class ProductController {
    private static final Logger log = LoggerFactory.getLogger(ProductController.class);
    @Autowired(required=false)
    private ProductService productService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<Product>> findByConditions(@PageableDefault(value=50) Pageable pageable, ProductPaginationDto paginationDto) {
        try {
            paginationDto = Optional.ofNullable(paginationDto).orElse(new ProductPaginationDto());
            paginationDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            Page<Product> result = this.productService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5408\u540c\u914d\u7f6e\u53ef\u8d2d\u6e05\u5355\u5546\u54c1\u6570\u636e")
    @GetMapping(value={"/findByContractProductQueryDto"})
    public Result<List<Product>> findByContractProductQueryDto(ContractProductQueryDto dto) {
        try {
            List<Product> result = this.productService.findByContractProductQueryDto(dto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.productService.updateDelFlagByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e0a\u67b6")
    @PatchMapping(value={"/upShelf"})
    public Result<?> upShelf(@RequestBody List<String> ids) {
        try {
            this.productService.upShelf(ids);
            return Result.ok((String)"\u4e0a\u67b6\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e0b\u67b6")
    @PatchMapping(value={"/downShelf"})
    public Result<?> downShelf(@RequestBody List<String> ids) {
        try {
            this.productService.downShelf(ids);
            return Result.ok((String)"\u4e0b\u67b6\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5546\u54c1\u7f16\u7801\u4e0a\u67b6")
    @PatchMapping(value={"/upShelfByProductCodes"})
    public Result<?> upShelfByProductCodes(@RequestBody List<String> productCodeList) {
        try {
            this.productService.upShelfByProductCodes(productCodeList);
            return Result.ok((String)"\u4e0a\u67b6\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5546\u54c1\u7f16\u7801\u4e0b\u67b6")
    @PatchMapping(value={"/downShelfByProductCodes"})
    public Result<?> downShelfByProductCodes(@RequestBody List<String> productCodeList) {
        try {
            this.productService.downShelfByProductCodes(productCodeList);
            return Result.ok((String)"\u4e0b\u67b6\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.productService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.productService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u62c9\u53d6\u6570\u636e\u4e2d\u53f0-MDG\u7269\u6599\u6570\u636e")
    @PostMapping(value={"/pullMaterialList"})
    public Result<?> pullMaterialList(@RequestBody MasterDataMdgBaseDto dto) {
        try {
            this.productService.pullMaterialList(dto);
            return Result.ok((String)"\u6279\u91cf\u62c9\u53d6\u6570\u636e\u4e2d\u53f0-MDG\u7269\u6599\u6570\u636e\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

