/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.product.local.entity.ProductMaterial;
import com.biz.crm.mdm.business.product.local.mapper.ProductMaterialMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class ProductMaterialRepository
extends ServiceImpl<ProductMaterialMapper, ProductMaterial> {
    public List<ProductMaterial> findByProductCodes(List<String> productCodeList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(ProductMaterial::getProductCode, productCodeList)).list();
    }

    public void deleteByProductCodes(List<String> productCodes) {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQuery.eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(ProductMaterial::getProductCode, productCodes);
        ((ProductMaterialMapper)this.baseMapper).delete((Wrapper)lambdaQuery);
    }

    public Integer countByMaterialCodes(List<String> materialCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(ProductMaterial::getMaterialCode, materialCodes)).count();
    }

    public Set<String> findProductCodeByMaterialCode(String materialCode) {
        return ((ProductMaterialMapper)this.baseMapper).findProductCodeByMaterialCode(materialCode, TenantUtils.getTenantCode(), EnableStatusEnum.ENABLE.getCode(), DelFlagStatusEnum.NORMAL.getCode());
    }
}

