/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.product.local.entity.Product;
import com.biz.crm.mdm.business.product.local.mapper.ProductMapper;
import com.biz.crm.mdm.business.product.sdk.dto.ContractProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.dto.DisplayProductDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductPaginationDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.enums.IsShelfEnum;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
public class ProductRepository
extends ServiceImpl<ProductMapper, Product> {
    private static final Integer SIZE = 1000;

    public Page<Product> findByConditions(Page<Product> page, ProductPaginationDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((ProductMapper)this.baseMapper).findByConditions(page, dto);
    }

    public Page<ProductVo> findVoByConditions(Page<ProductVo> page, ProductPaginationDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((ProductMapper)this.baseMapper).findVoByConditions(page, dto);
    }

    public Product findById(String id) {
        return (Product)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public List<Product> findByProductCodes(List<String> productCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(Product::getProductCode, productCodes)).list();
    }

    public List<Product> findByIdsOrProductCodes(List<String> ids, List<String> productCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.in(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)ids), UuidEntity::getId, (Collection)ids)).or()).in(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)productCodes), Product::getProductCode, (Collection)productCodes);
        })).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void updateIsShelfByIds(List<String> ids, String code) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(Product::getIsShelf, (Object)code)).update();
    }

    public void updateIsShelfByByProductCodes(List<String> productCodeList, String code) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(Product::getProductCode, productCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(Product::getIsShelf, (Object)code)).update();
    }

    public Integer countByProductLevelCodesAndDelFlag(List<String> productLevelCodes, String delFlag) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotBlank((CharSequence)delFlag), UuidFlagOpEntity::getDelFlag, (Object)delFlag)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(org.apache.commons.collections.CollectionUtils.isNotEmpty(productLevelCodes), Product::getProductLevelCode, productLevelCodes)).count();
    }

    public List<ProductVo> findByProductLevelCodes(List<String> productLevelCodeList) {
        return ((ProductMapper)this.baseMapper).findByProductLevelCodes(productLevelCodeList, TenantUtils.getTenantCode(), DelFlagStatusEnum.NORMAL.getCode());
    }

    public Set<String> findProductLevelCodeSetByProductCodes(Set<String> productCodeSet) {
        return ((ProductMapper)this.baseMapper).findProductLevelCodeSetByProductCodes(productCodeSet, TenantUtils.getTenantCode());
    }

    public Product findByProductCode(String code, String delFlag) {
        return (Product)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Product::getProductCode, (Object)code)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)delFlag)).one());
    }

    public List<Product> findByProductQueryDto(ProductQueryDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<Object> list = Lists.newLinkedList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getProductCodeList())) {
            for (List item : Lists.partition((List)Lists.newArrayList((Iterable)dto.getProductCodeList()), (int)SIZE)) {
                dto.setProductCodeList(item);
                List<Product> cur = ((ProductMapper)this.baseMapper).findByProductQueryDto(dto);
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(cur)) continue;
                list.addAll(cur);
            }
        } else {
            list = ((ProductMapper)this.baseMapper).findByProductQueryDto(dto);
        }
        return list;
    }

    public List<Product> findByContractProductQueryDto(ContractProductQueryDto dto) {
        String tenantCode = TenantUtils.getTenantCode();
        String delFlag = DelFlagStatusEnum.NORMAL.getCode();
        String enableStatus = EnableStatusEnum.ENABLE.getCode();
        String shelfFlag = IsShelfEnum.UP.getCode();
        return ((ProductMapper)this.baseMapper).findByContractProductQueryDto(dto, tenantCode, delFlag, enableStatus, shelfFlag);
    }

    public List<Product> queryCondition(ProductDto dto) {
        if (ObjectUtils.isEmpty((Object)dto)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)dto.getProductBrandCode()) && StringUtils.isEmpty((CharSequence)dto.getProductCode()) && StringUtils.isEmpty((CharSequence)dto.getProductLevelCode()) && StringUtils.isEmpty((CharSequence)dto.getProductCategoryCode()) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getExcludeMainCategoryList()) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getIncludeMainCategoryList())) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((CharSequence)dto.getProductBrandCode()), Product::getProductBrandCode, (Object)dto.getProductBrandCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductCode()), Product::getProductCode, (Object)dto.getProductCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductCategoryCode()), Product::getProductCategoryCode, (Object)dto.getProductCategoryCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductLevelCode()), Product::getProductLevelCode, (Object)dto.getProductLevelCode())).notIn(!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getExcludeMainCategoryList()), Product::getMainCategory, (Collection)dto.getExcludeMainCategoryList())).in(!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getIncludeMainCategoryList()), Product::getMainCategory, (Collection)dto.getIncludeMainCategoryList())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public Product findByProductPlanningDetails(String productCode) {
        return (Product)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Product::getProductCode, (Object)productCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<Product> findAllListByCodeList(List<String> productCodeList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(Product::getProductCode, productCodeList)).list();
    }

    public Product finByUnitTypeCode(String unitTypeCode) {
        return (Product)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(Product::getProductCode, (Object)unitTypeCode)).one());
    }

    public List<String> findAllProductCode(String tenantCode) {
        return ((ProductMapper)this.baseMapper).findAllProductCode(tenantCode);
    }

    public List<CommonSelectVo> getProductByCodes(List<List<String>> codes, String tenantCode) {
        return ((ProductMapper)this.baseMapper).getProductByCodes(codes, tenantCode);
    }

    public List<Product> findByCodes(List<String> codes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(codes)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(Product::getProductCode, codes)).list();
    }

    public Map<String, String> findNameByIdsOrCodes(List<String> ids, List<String> productCodes) {
        Assert.isTrue((!CollectionUtils.isEmpty(ids) || !CollectionUtils.isEmpty(productCodes) ? 1 : 0) != 0, (String)"\u53c2\u6570Id\u6216\u8005\u7f16\u7801\u81f3\u5c11\u6709\u4e00\u4e2a");
        HashMap resultMap = Maps.newHashMap();
        String tenantCode = TenantUtils.getTenantCode();
        List<ProductVo> productVos = ((ProductMapper)this.baseMapper).findNameByIdsOrCodes(ids, productCodes, tenantCode);
        if (CollectionUtils.isEmpty(productVos)) {
            return resultMap;
        }
        productVos.forEach(o -> {
            if (!CollectionUtils.isEmpty((Collection)ids)) {
                resultMap.put(o.getId(), o.getProductName());
            } else if (!CollectionUtils.isEmpty((Collection)productCodes)) {
                resultMap.put(o.getProductCode(), o.getProductName());
            }
        });
        return resultMap;
    }

    public List<Product> findPackageDescOrBrandOrgOrCategory(DisplayProductDto displayProductDto) {
        String brandOrg = displayProductDto.getBrandOrg();
        String productCategoryCode = displayProductDto.getProductCategoryCode();
        String packageDesc = displayProductDto.getPackageDesc();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(StringUtils.isNotEmpty((CharSequence)brandOrg), Product::getBrandOrg, (Object)brandOrg)).eq(StringUtils.isNotEmpty((CharSequence)productCategoryCode), Product::getProductCategoryCode, (Object)productCategoryCode)).eq(StringUtils.isNotEmpty((CharSequence)packageDesc), Product::getPackageDesc, (Object)packageDesc)).select(new SFunction[]{Product::getBrandOrg, Product::getProductCategoryCode, Product::getProductCategoryName, Product::getPackageDesc}).list();
    }

    public ProductVo findByCode(String productCode, Boolean enableStatusFlag) {
        ProductDto dto = new ProductDto();
        dto.setProductCode(productCode);
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        if (enableStatusFlag.booleanValue()) {
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((ProductMapper)this.baseMapper).findByProductDto(dto);
    }
}

