/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.local.service.internal;

import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.biz.crm.mdm.business.product.local.entity.ProductMaterial;
import com.biz.crm.mdm.business.product.local.repository.ProductMaterialRepository;
import com.biz.crm.mdm.business.product.local.service.ProductMaterialService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="productMaterialService")
public class ProductMaterialServiceImpl
implements ProductMaterialService {
    @Autowired(required=false)
    private ProductMaterialRepository productMaterialRepository;
    @Autowired(required=false)
    private MaterialVoService materialVoService;

    @Override
    public List<ProductMaterial> findByProductCodes(List<String> productCodeList) {
        if (CollectionUtils.isEmpty(productCodeList)) {
            return Lists.newLinkedList();
        }
        List<ProductMaterial> list = this.productMaterialRepository.findByProductCodes(productCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        List materialCodeList = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getMaterialCode())).map(ProductMaterial::getMaterialCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(materialCodeList)) {
            return list;
        }
        List materialVoList = this.materialVoService.findDetailByMaterialCodes((Set)Sets.newHashSet(materialCodeList));
        if (CollectionUtils.isEmpty((Collection)materialVoList)) {
            return list;
        }
        Map map = materialVoList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getMaterialCode())).collect(Collectors.toMap(MaterialVo::getMaterialCode, Function.identity(), (a, b) -> b));
        list.forEach(a -> {
            MaterialVo vo = (MaterialVo)map.get(a.getMaterialCode());
            if (Objects.nonNull(vo)) {
                a.setMaterialName(vo.getMaterialName());
            }
        });
        return list;
    }

    @Override
    @Transactional
    public void saveBatch(List<ProductMaterial> productMaterialList, String productCode) {
        Validate.notBlank((CharSequence)productCode, (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productMaterialRepository.deleteByProductCodes(Lists.newArrayList((Object[])new String[]{productCode}));
        if (CollectionUtils.isEmpty(productMaterialList)) {
            return;
        }
        Optional<ProductMaterial> first = productMaterialList.stream().filter(a -> StringUtils.isBlank((CharSequence)a.getProductCode()) || StringUtils.isBlank((CharSequence)a.getMaterialCode()) || !productCode.equals(a.getProductCode())).findFirst();
        Validate.isTrue((!first.isPresent() ? 1 : 0) != 0, (String)"\u5546\u54c1\u7f16\u7801\u6216\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u5fc5\u987b\u5c5e\u4e8e\u540c\u4e00\u5546\u54c1", (Object[])new Object[0]);
        Map<String, List<ProductMaterial>> map = productMaterialList.stream().collect(Collectors.groupingBy(ProductMaterial::getMaterialCode));
        map.entrySet().forEach(a -> Validate.isTrue((((List)a.getValue()).size() <= 1 ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u7684\u7269\u6599\u4fe1\u606f", (Object[])new Object[0]));
        for (ProductMaterial productMaterial : productMaterialList) {
            productMaterial.setId(null);
            productMaterial.setTenantCode(TenantUtils.getTenantCode());
        }
        this.productMaterialRepository.saveBatch(productMaterialList);
    }

    @Override
    public Integer countByMaterialCodes(List<String> materialCodes) {
        if (CollectionUtils.isEmpty(materialCodes)) {
            return 0;
        }
        return this.productMaterialRepository.countByMaterialCodes(materialCodes);
    }

    @Override
    public Set<String> findProductCodeByMaterialCode(String materialCode) {
        if (StringUtils.isBlank((CharSequence)materialCode)) {
            return Sets.newHashSet();
        }
        return this.productMaterialRepository.findProductCodeByMaterialCode(materialCode);
    }

    @Override
    @Transactional
    public void create(ProductMaterial productMaterial) {
        Validate.notNull((Object)((Object)productMaterial), (String)"\u7269\u6599\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        productMaterial.setTenantCode(TenantUtils.getTenantCode());
        this.productMaterialRepository.save((Object)productMaterial);
    }
}

