/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.material.unit.service.MaterialUnitVoService;
import com.biz.crm.mdm.business.price.sdk.service.PriceVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceFeeVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandBusinessFormatService;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.dto.RelateProductLevelCodeQueryDto;
import com.biz.crm.mdm.business.product.level.sdk.enums.ProductLevelEnum;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelService;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.MdgProductLevelVo;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.local.entity.Product;
import com.biz.crm.mdm.business.product.local.entity.ProductIntroduction;
import com.biz.crm.mdm.business.product.local.entity.ProductUnit;
import com.biz.crm.mdm.business.product.local.repository.ProductRepository;
import com.biz.crm.mdm.business.product.local.service.ProductIntroductionService;
import com.biz.crm.mdm.business.product.local.service.ProductService;
import com.biz.crm.mdm.business.product.local.service.ProductUnitService;
import com.biz.crm.mdm.business.product.sdk.dto.ContractProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductEventDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductPaginationDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductSingleEventDto;
import com.biz.crm.mdm.business.product.sdk.enums.IsShelfEnum;
import com.biz.crm.mdm.business.product.sdk.event.ProductEventListener;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductPlanningDetailsVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.service.MasterDataMdgService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgMaterialVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="productService")
public class ProductServiceImpl
implements ProductService {
    private static final Logger log = LoggerFactory.getLogger(ProductServiceImpl.class);
    private static volatile Cache<String, List<Product>> cache = null;
    @Autowired(required=false)
    private ProductRepository productRepository;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private ProductIntroductionService productIntroductionService;
    @Autowired(required=false)
    private PriceVoService priceVoService;
    @Autowired(required=false)
    private ProductLevelService productLevelService;
    @Autowired(required=false)
    private ProductBrandService productBrandService;
    @Autowired(required=false)
    @Lazy
    private List<ProductEventListener> listeners;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private MasterDataMdgService masterDataMdgService;
    @Autowired(required=false)
    private ProductUnitService productUnitService;
    @Autowired(required=false)
    private MaterialUnitVoService materialUnitVoService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private ProductBrandBusinessFormatService productBrandBusinessFormatService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProductServiceImpl() {
        if (cache != null) return;
        Class<ProductServiceImpl> clazz = ProductServiceImpl.class;
        synchronized (ProductServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private Product setProductData(String tenantCode, Set<String> productLevelCodeSet, Set<String> productBrandCodeSet, List<MdgProductLevelVo> productLevelList, List<ProductBrandVo> productBrandList, MasterDataMdgMaterialVo masterDataMdgSupplierBankVo, Map<String, Set<String>> businessFormatBrandMap) {
        Product product = new Product();
        product.setProductCode(masterDataMdgSupplierBankVo.getMatnr());
        product.setProductName(masterDataMdgSupplierBankVo.getMaktx());
        product.setBaseUnitDes(masterDataMdgSupplierBankVo.getMeinsdesc());
        product.setProductType(masterDataMdgSupplierBankVo.getMtart());
        product.setProductOrg(masterDataMdgSupplierBankVo.getMatkl());
        product.setBizField(masterDataMdgSupplierBankVo.getMbrsh());
        product.setProductOrgDesc(masterDataMdgSupplierBankVo.getMbrsh());
        product.setProductOrgDesc(masterDataMdgSupplierBankVo.getMbrsh());
        product.setProductIncoming(masterDataMdgSupplierBankVo.getZzmat010());
        product.setUnitWeight(masterDataMdgSupplierBankVo.getGewei());
        product.setVolumeWeight(masterDataMdgSupplierBankVo.getVoleh());
        product.setPackageQuantityMin(masterDataMdgSupplierBankVo.getZfxbz());
        product.setPackageQuantityMinUnite(masterDataMdgSupplierBankVo.getZzmat008());
        product.setNetWeight(new BigDecimal(masterDataMdgSupplierBankVo.getNtgew().trim()));
        product.setPackageProduct(masterDataMdgSupplierBankVo.getMagrv());
        product.setPackageDesc(masterDataMdgSupplierBankVo.getBezei());
        product.setPackageReport(masterDataMdgSupplierBankVo.getZzmat901());
        product.setPackageReportDescDesc(masterDataMdgSupplierBankVo.getZzmat901dng());
        product.setPackageTrueProps(masterDataMdgSupplierBankVo.getZzmat011());
        product.setTaste(masterDataMdgSupplierBankVo.getZzmat025());
        product.setCartonBarCode(masterDataMdgSupplierBankVo.getZzmat903());
        product.setForte(masterDataMdgSupplierBankVo.getLaeng());
        product.setWidth(masterDataMdgSupplierBankVo.getBreit());
        product.setHigh(masterDataMdgSupplierBankVo.getHoehe());
        product.setPackageScale(masterDataMdgSupplierBankVo.getZzmat004());
        product.setLiquidStateProductDensity(masterDataMdgSupplierBankVo.getZzmat007());
        product.setBusinessAmount(masterDataMdgSupplierBankVo.getVolum());
        product.setLiquidStateProductDensity(masterDataMdgSupplierBankVo.getWgbez());
        product.setBarCode(masterDataMdgSupplierBankVo.getZzmat902());
        product.setProductCategoryCode(masterDataMdgSupplierBankVo.getZzmat030());
        product.setProductCategoryName(masterDataMdgSupplierBankVo.getZzmat030desc());
        product.setProductLevelCode(masterDataMdgSupplierBankVo.getZzmat034());
        product.setProductLevelName(masterDataMdgSupplierBankVo.getBackup2());
        product.setProductBrandCode(masterDataMdgSupplierBankVo.getZzmat031());
        product.setProductBrandName(masterDataMdgSupplierBankVo.getBackup1());
        product.setBusinessFormatCode(masterDataMdgSupplierBankVo.getSpart());
        product.setBaseUnit(masterDataMdgSupplierBankVo.getMeins());
        if ("ST".equals(product.getBaseUnit())) {
            product.setBaseUnit("PC");
        }
        product.setSpec(masterDataMdgSupplierBankVo.getZzmat039());
        product.setBrandOrg(masterDataMdgSupplierBankVo.getZzmat033desc());
        Integer expirationDate = new Integer(masterDataMdgSupplierBankVo.getMhdhb().trim());
        product.setExpirationDate(expirationDate);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)masterDataMdgSupplierBankVo.getZzmat036())) {
            BigDecimal bigDecimal = new BigDecimal(masterDataMdgSupplierBankVo.getZzmat036().trim());
            product.setRate(bigDecimal);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)masterDataMdgSupplierBankVo.getMstae())) {
            product.setIsShelf(BooleanEnum.FALSE.getCapital());
            product.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
        } else {
            product.setIsShelf(BooleanEnum.TRUE.getCapital());
            product.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        }
        product.setTenantCode(tenantCode);
        product.setDelFlag(EnableStatusEnum.ENABLE.getCode());
        if (StringUtils.hasText((String)product.getProductBrandCode()) && StringUtils.hasText((String)product.getBusinessFormatCode())) {
            HashSet businessFormatSet = businessFormatBrandMap.get(product.getProductBrandCode());
            if (CollectionUtils.isEmpty(businessFormatSet)) {
                businessFormatSet = Sets.newHashSet();
            }
            businessFormatSet.add(product.getBusinessFormatCode());
            businessFormatBrandMap.put(product.getProductBrandCode(), businessFormatSet);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)masterDataMdgSupplierBankVo.getZzmat031()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)masterDataMdgSupplierBankVo.getBackup1()) && !productBrandCodeSet.contains(masterDataMdgSupplierBankVo.getZzmat031())) {
            ProductBrandVo productBrand = new ProductBrandVo();
            productBrandCodeSet.add(masterDataMdgSupplierBankVo.getZzmat031());
            productBrand.setProductBrandCode(masterDataMdgSupplierBankVo.getZzmat031());
            productBrand.setProductBrandName(masterDataMdgSupplierBankVo.getBackup1());
            productBrand.setTenantCode(tenantCode);
            productBrand.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            productBrand.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            productBrandList.add(productBrand);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)masterDataMdgSupplierBankVo.getZzmat034()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)masterDataMdgSupplierBankVo.getZzmat030())) {
            MdgProductLevelVo productLevel;
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)masterDataMdgSupplierBankVo.getZzmat034()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)masterDataMdgSupplierBankVo.getBackup2()) && !productLevelCodeSet.contains(masterDataMdgSupplierBankVo.getZzmat034())) {
                productLevelCodeSet.add(masterDataMdgSupplierBankVo.getZzmat034());
                productLevel = new MdgProductLevelVo();
                productLevel.setProductLevelType(ProductLevelEnum.items);
                productLevel.setProductLevelCode(masterDataMdgSupplierBankVo.getZzmat034());
                productLevel.setProductLevelName(masterDataMdgSupplierBankVo.getBackup2());
                productLevel.setParentCode(masterDataMdgSupplierBankVo.getZzmat030());
                productLevel.setTenantCode(tenantCode);
                productLevel.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                productLevel.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                productLevelList.add(productLevel);
            } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)masterDataMdgSupplierBankVo.getZzmat030()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)masterDataMdgSupplierBankVo.getZzmat030desc()) && !productLevelCodeSet.contains(masterDataMdgSupplierBankVo.getZzmat030())) {
                productLevelCodeSet.add(masterDataMdgSupplierBankVo.getZzmat030());
                productLevel = new MdgProductLevelVo();
                productLevel.setProductLevelType(ProductLevelEnum.category);
                productLevel.setProductLevelCode(masterDataMdgSupplierBankVo.getZzmat030());
                productLevel.setProductLevelName(masterDataMdgSupplierBankVo.getZzmat030desc());
                productLevel.setTenantCode(tenantCode);
                productLevel.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                productLevel.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                productLevelList.add(productLevel);
            }
        }
        return product;
    }

    @Override
    public Page<Product> findByConditions(Pageable pageable, ProductPaginationDto dto) {
        List<ProductUnit> productUnits;
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new ProductPaginationDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<Product> pageResult = this.productRepository.findByConditions((Page<Product>)page, dto);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return pageResult;
        }
        List<Object> productLevelCodes = Lists.newLinkedList();
        Map<Object, Object> productLevelMap = Maps.newHashMap();
        List productLevelVos = Lists.newLinkedList();
        Boolean flag = pageResult != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageResult.getRecords());
        if (Boolean.TRUE.equals(flag)) {
            productLevelCodes = pageResult.getRecords().stream().filter(a -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)a.getProductLevelCode())).map(Product::getProductLevelCode).collect(Collectors.toList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)productLevelCodes)) {
            productLevelVos = this.productLevelVoSdkService.findListByCodes((List)productLevelCodes);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)productLevelVos)) {
            productLevelMap = productLevelVos.stream().filter(a -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)a.getProductLevelCode()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)a.getProductLevelName())).collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, ProductLevelVo::getProductLevelName, (a, b) -> a));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(productUnits = this.productUnitService.findByProductCodes((ArrayList)pageResult.getRecords().stream().map(Product::getProductCode).collect(Collectors.toList())))) {
            Map<String, List<ProductUnit>> collect = productUnits.stream().collect(Collectors.groupingBy(ProductUnit::getProductCode));
            pageResult.getRecords().forEach(s -> s.setUnitList((List)collect.get(s.getProductCode())));
        }
        if (Boolean.TRUE.equals(flag)) {
            for (Product item : pageResult.getRecords()) {
                item.setProductLevelName(productLevelMap.getOrDefault(item.getProductLevelCode(), ""));
                item.setNetWeight(item.getNetWeight() == null ? BigDecimal.ZERO : item.getNetWeight());
            }
        }
        return pageResult;
    }

    @Override
    public List<Product> findDetailsByIdsOrProductCodes(List<String> ids, List<String> productCodes) {
        String cacheKey;
        List<Product> graph;
        if (org.apache.commons.collections.CollectionUtils.isEmpty(ids) && org.apache.commons.collections.CollectionUtils.isEmpty(productCodes)) {
            return Lists.newLinkedList();
        }
        StringBuilder sb = new StringBuilder();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(ids)) {
            sb.append(org.apache.commons.lang3.StringUtils.join((Object[])new List[]{ids}));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(productCodes)) {
            sb.append(org.apache.commons.lang3.StringUtils.join((Object[])new List[]{productCodes}));
        }
        if ((graph = (List<Product>)cache.getIfPresent((Object)(cacheKey = org.apache.commons.lang3.StringUtils.join((Object[])new String[]{TenantUtils.getTenantCode(), sb.toString()})))) == null) {
            graph = this.productRepository.findByIdsOrProductCodes(ids, productCodes);
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    @Override
    @Transactional
    public Product create(Product product) {
        this.createValidation(product);
        product.setId(null);
        product.setTenantCode(TenantUtils.getTenantCode());
        product.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        product.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.productRepository.saveOrUpdate((Object)product);
        return product;
    }

    @Override
    @Transactional
    public Product update(Product product) {
        this.updateValidation(product);
        String currentId = product.getId();
        Product current = this.productRepository.findById(currentId);
        Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)product.getProductCode().equals(current.getProductCode()), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        product.setTenantCode(TenantUtils.getTenantCode());
        this.productRepository.saveOrUpdate((Object)product);
        return product;
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List list = this.productVoService.findDetailsByIdsOrProductCodes(ids, null);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        this.productRepository.updateDelFlagByIds(ids);
        ProductEventDto productEventDto = new ProductEventDto();
        for (ProductVo productVo : list) {
            productEventDto.setOriginal(productVo);
            productEventDto.setNewest(null);
            SerializableBiConsumer & Serializable onDelete = ProductEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)productEventDto, ProductEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Override
    @Transactional
    public void upShelf(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productRepository.updateIsShelfByIds(ids, IsShelfEnum.UP.getCode());
        List list = this.productVoService.findDetailsByIdsOrProductCodes(ids, null);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (ProductVo productVo : list) {
            ProductSingleEventDto productSingleEventDto = new ProductSingleEventDto();
            productSingleEventDto.setId(productVo.getId());
            JSONObject object1 = new JSONObject();
            object1.put("isShelf", (Object)IsShelfEnum.DOWN.getCode());
            object1.put("enableStatus", (Object)productVo.getEnableStatus());
            object1.put("productCode", (Object)productVo.getProductCode());
            object1.put("productLevelCode", (Object)productVo.getProductLevelCode());
            JSONObject object2 = new JSONObject();
            object2.put("isShelf", (Object)IsShelfEnum.UP.getCode());
            object2.put("enableStatus", (Object)productVo.getEnableStatus());
            object2.put("productCode", (Object)productVo.getProductCode());
            object2.put("productLevelCode", (Object)productVo.getProductLevelCode());
            productSingleEventDto.setOriginal((Object)object1);
            productSingleEventDto.setNewest((Object)object2);
            SerializableBiConsumer & Serializable onUpShelf = ProductEventListener::onUpShelf;
            this.nebulaNetEventClient.publish((NebulaEventDto)productSingleEventDto, ProductEventListener.class, (SerializableBiConsumer)onUpShelf);
        }
    }

    @Override
    @Transactional
    public void downShelf(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productRepository.updateIsShelfByIds(ids, IsShelfEnum.DOWN.getCode());
        List list = this.productVoService.findDetailsByIdsOrProductCodes(ids, null);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (ProductVo productVo : list) {
            ProductSingleEventDto productSingleEventDto = new ProductSingleEventDto();
            productSingleEventDto.setId(productVo.getId());
            JSONObject object1 = new JSONObject();
            object1.put("isShelf", (Object)IsShelfEnum.UP.getCode());
            object1.put("enableStatus", (Object)productVo.getEnableStatus());
            object1.put("productCode", (Object)productVo.getProductCode());
            object1.put("productLevelCode", (Object)productVo.getProductLevelCode());
            JSONObject object2 = new JSONObject();
            object2.put("isShelf", (Object)IsShelfEnum.DOWN.getCode());
            object2.put("enableStatus", (Object)productVo.getEnableStatus());
            object2.put("productCode", (Object)productVo.getProductCode());
            object2.put("productLevelCode", (Object)productVo.getProductLevelCode());
            productSingleEventDto.setOriginal((Object)object1);
            productSingleEventDto.setNewest((Object)object2);
            SerializableBiConsumer & Serializable onDownShelf = ProductEventListener::onDownShelf;
            this.nebulaNetEventClient.publish((NebulaEventDto)productSingleEventDto, ProductEventListener.class, (SerializableBiConsumer)onDownShelf);
        }
    }

    @Override
    @Transactional
    public void upShelfByProductCodes(List<String> productCodeList) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(productCodeList), (String)"productCode\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productRepository.updateIsShelfByByProductCodes(productCodeList, IsShelfEnum.UP.getCode());
        List list = this.productVoService.findDetailsByIdsOrProductCodes(null, productCodeList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (ProductVo productVo : list) {
            ProductSingleEventDto productSingleEventDto = new ProductSingleEventDto();
            productSingleEventDto.setId(productVo.getId());
            JSONObject object1 = new JSONObject();
            object1.put("isShelf", (Object)IsShelfEnum.DOWN.getCode());
            object1.put("enableStatus", (Object)productVo.getEnableStatus());
            object1.put("productCode", (Object)productVo.getProductCode());
            object1.put("productLevelCode", (Object)productVo.getProductLevelCode());
            JSONObject object2 = new JSONObject();
            object2.put("isShelf", (Object)IsShelfEnum.UP.getCode());
            object2.put("enableStatus", (Object)productVo.getEnableStatus());
            object2.put("productCode", (Object)productVo.getProductCode());
            object2.put("productLevelCode", (Object)productVo.getProductLevelCode());
            productSingleEventDto.setOriginal((Object)object1);
            productSingleEventDto.setNewest((Object)object2);
            SerializableBiConsumer & Serializable onUpShelf = ProductEventListener::onUpShelf;
            this.nebulaNetEventClient.publish((NebulaEventDto)productSingleEventDto, ProductEventListener.class, (SerializableBiConsumer)onUpShelf);
        }
    }

    @Override
    @Transactional
    public void downShelfByProductCodes(List<String> productCodeList) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(productCodeList), (String)"productCode\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productRepository.updateIsShelfByByProductCodes(productCodeList, IsShelfEnum.DOWN.getCode());
        List list = this.productVoService.findDetailsByIdsOrProductCodes(null, productCodeList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (ProductVo productVo : list) {
            ProductSingleEventDto productSingleEventDto = new ProductSingleEventDto();
            productSingleEventDto.setId(productVo.getId());
            JSONObject object1 = new JSONObject();
            object1.put("isShelf", (Object)IsShelfEnum.UP.getCode());
            object1.put("enableStatus", (Object)productVo.getEnableStatus());
            object1.put("productCode", (Object)productVo.getProductCode());
            object1.put("productLevelCode", (Object)productVo.getProductLevelCode());
            JSONObject object2 = new JSONObject();
            object2.put("isShelf", (Object)IsShelfEnum.DOWN.getCode());
            object2.put("enableStatus", (Object)productVo.getEnableStatus());
            object2.put("productCode", (Object)productVo.getProductCode());
            object2.put("productLevelCode", (Object)productVo.getProductLevelCode());
            productSingleEventDto.setOriginal((Object)object1);
            productSingleEventDto.setNewest((Object)object2);
            SerializableBiConsumer & Serializable onDownShelf = ProductEventListener::onDownShelf;
            this.nebulaNetEventClient.publish((NebulaEventDto)productSingleEventDto, ProductEventListener.class, (SerializableBiConsumer)onDownShelf);
        }
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        List list = this.productVoService.findDetailsByIdsOrProductCodes(ids, null);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (ProductVo productVo : list) {
            ProductSingleEventDto productSingleEventDto = new ProductSingleEventDto();
            productSingleEventDto.setId(productVo.getId());
            JSONObject object1 = new JSONObject();
            object1.put("isShelf", (Object)productVo.getIsShelf());
            object1.put("enableStatus", (Object)EnableStatusEnum.DISABLE.getCode());
            object1.put("productCode", (Object)productVo.getProductCode());
            object1.put("productLevelCode", (Object)productVo.getProductLevelCode());
            JSONObject object2 = new JSONObject();
            object2.put("isShelf", (Object)productVo.getIsShelf());
            object2.put("enableStatus", (Object)EnableStatusEnum.ENABLE.getCode());
            object2.put("productCode", (Object)productVo.getProductCode());
            object2.put("productLevelCode", (Object)productVo.getProductLevelCode());
            productSingleEventDto.setOriginal((Object)object1);
            productSingleEventDto.setNewest((Object)object2);
            SerializableBiConsumer & Serializable onEnable = ProductEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)productSingleEventDto, ProductEventListener.class, (SerializableBiConsumer)onEnable);
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        List list = this.productVoService.findDetailsByIdsOrProductCodes(ids, null);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (ProductVo productVo : list) {
            ProductSingleEventDto productSingleEventDto = new ProductSingleEventDto();
            productSingleEventDto.setId(productVo.getId());
            JSONObject object1 = new JSONObject();
            object1.put("isShelf", (Object)productVo.getIsShelf());
            object1.put("enableStatus", (Object)EnableStatusEnum.ENABLE.getCode());
            object1.put("productCode", (Object)productVo.getProductCode());
            object1.put("productLevelCode", (Object)productVo.getProductLevelCode());
            JSONObject object2 = new JSONObject();
            object2.put("isShelf", (Object)productVo.getIsShelf());
            object2.put("enableStatus", (Object)EnableStatusEnum.DISABLE.getCode());
            object2.put("productCode", (Object)productVo.getProductCode());
            object2.put("productLevelCode", (Object)productVo.getProductLevelCode());
            productSingleEventDto.setOriginal((Object)object1);
            productSingleEventDto.setNewest((Object)object2);
        }
    }

    @Override
    public Integer countByProductLevelCodesAndDelFlag(List<String> productLevelCodes, String delFlag) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(productLevelCodes) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)delFlag)) {
            return 0;
        }
        return this.productRepository.countByProductLevelCodesAndDelFlag(productLevelCodes, delFlag);
    }

    @Override
    public Set<String> findProductLevelCodeSetByProductCodes(Set<String> productCodeSet) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(productCodeSet)) {
            return Sets.newHashSet();
        }
        return this.productRepository.findProductLevelCodeSetByProductCodes(productCodeSet);
    }

    @Override
    public Product findByProductCode(String code) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.productRepository.findByProductCode(code, DelFlagStatusEnum.NORMAL.getCode());
    }

    @Override
    public List<Product> findByContractProductQueryDto(ContractProductQueryDto dto) {
        if (Objects.isNull(dto) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getProductCodeSet()) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getProductLevelCodeSet())) {
            return Lists.newLinkedList();
        }
        HashSet levelCodeSet = Sets.newHashSet();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getProductLevelCodeSet())) {
            RelateProductLevelCodeQueryDto queryDto = new RelateProductLevelCodeQueryDto();
            queryDto.setSearchType(Integer.valueOf(-1));
            queryDto.setProductLevelCodeSet(dto.getProductLevelCodeSet());
            Map mapLevel = this.productLevelVoSdkService.findByRelateProductLevelCodeQueryDto(queryDto);
            if (!mapLevel.isEmpty()) {
                levelCodeSet.addAll(mapLevel.keySet());
            }
        }
        dto.setProductLevelCodeSet((Set)levelCodeSet);
        dto.setUnionType(Boolean.FALSE);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getProductCodeSet()) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getProductLevelCodeSet())) {
            dto.setUnionType(Boolean.TRUE);
        }
        return this.productRepository.findByContractProductQueryDto(dto);
    }

    @Override
    public ProductPlanningDetailsVo findByProductPlanningDetails(String productCode, String customerCode, String businessModel, String startDate) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)productCode)) {
            return new ProductPlanningDetailsVo();
        }
        Product planningDetails = this.productRepository.findByProductPlanningDetails(productCode);
        if (ObjectUtils.isEmpty((Object)((Object)planningDetails))) {
            throw new RuntimeException("\u4ef7\u683c\u7ba1\u7406\u67e5\u8be2\u6570\u636e\u4e0d\u4e0d\u5b58\u5728\uff01");
        }
        ProductPlanningDetailsVo vo = new ProductPlanningDetailsVo(planningDetails.getProductCode(), planningDetails.getProductName(), planningDetails.getProductBrandName(), planningDetails.getProductBrandCode(), planningDetails.getRate());
        PriceFeeVo feeVo = this.priceVoService.findByGoodsCode(planningDetails.getProductCode(), customerCode, businessModel, startDate);
        BeanUtils.copyProperties((Object)feeVo, (Object)vo);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pullMaterialList(MasterDataMdgBaseDto dto) {
        if (ObjectUtils.isEmpty((Object)dto)) {
            dto = new MasterDataMdgBaseDto();
        }
        int pageNum = 1;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dto.getPageNum())) {
            pageNum = Integer.parseInt(dto.getPageNum());
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dto.getPageSize())) {
            dto.setPageSize("400");
        }
        boolean lock = true;
        String lockKey = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dto.getDs())) {
            lockKey = dto.getDs();
        }
        boolean loopFlag = true;
        int loopMAX = 40;
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            HashSet<String> codeSet = new HashSet<String>(4096);
            HashSet<String> productBrandCodeSet = new HashSet<String>(4096);
            HashSet<String> productLevelCodeSet = new HashSet<String>(4096);
            HashMap businessFormatBrandMap = Maps.newHashMap();
            while (loopFlag && pageNum <= loopMAX) {
                dto.setPageNum(String.valueOf(pageNum));
                log.info("\u62c9\u53d6MDG\u5546\u54c1\u4fe1\u606f,\u9875\u7801[{}],\u6bcf\u9875\u5927\u5c0f[{}]", (Object)dto.getPageNum(), (Object)dto.getPageSize());
                List masterDataMdgMaterialVos = this.masterDataMdgService.pullMaterialList(dto);
                ++pageNum;
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)masterDataMdgMaterialVos)) {
                    loopFlag = false;
                    continue;
                }
                ArrayList<MdgProductLevelVo> productLevelList = new ArrayList<MdgProductLevelVo>();
                ArrayList<ProductBrandVo> productBrandList = new ArrayList<ProductBrandVo>();
                List<Product> pullList = this.materialValidate(masterDataMdgMaterialVos, productLevelList, productBrandList, codeSet, productBrandCodeSet, productLevelCodeSet, businessFormatBrandMap);
                ArrayList<Product> saveList = new ArrayList<Product>();
                ArrayList<Product> updateList = new ArrayList<Product>();
                ArrayList<MdgProductLevelVo> saveProductLevelList = new ArrayList<MdgProductLevelVo>();
                ArrayList<MdgProductLevelVo> updateProductLevelList = new ArrayList<MdgProductLevelVo>();
                ArrayList<ProductBrandVo> saveProductBrandList = new ArrayList<ProductBrandVo>();
                ArrayList<ProductBrandVo> updateProductBrandList = new ArrayList<ProductBrandVo>();
                this.filterProduct(pullList, saveList, updateList);
                this.filterProductLevel(productLevelList, saveProductLevelList, updateProductLevelList);
                this.filterProductBrand(productBrandList, saveProductBrandList, updateProductBrandList);
                this.saveOrUpdateBatch(saveList, updateList, saveProductLevelList, updateProductLevelList, saveProductBrandList, updateProductBrandList);
            }
            this.productBrandBusinessFormatService.deleteAll((Map)businessFormatBrandMap);
            this.productBrandBusinessFormatService.saveBusinessFormatBrand((Map)businessFormatBrandMap);
        }
        finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    private void filterProductIntroductionBrand(List<ProductIntroduction> productIntroductionList, List<ProductIntroduction> saveProductIntroductionList, List<ProductIntroduction> updateProductIntroductionList) {
        if (CollectionUtil.isEmpty(productIntroductionList)) {
            return;
        }
        List<String> codeList = productIntroductionList.stream().filter(v -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)v.getProductCode())).map(ProductIntroduction::getProductCode).distinct().collect(Collectors.toList());
        List<ProductIntroduction> productIntroductions = this.productIntroductionService.findAllListByCodeList(codeList);
        if (CollectionUtil.isEmpty(productIntroductions)) {
            saveProductIntroductionList.addAll(productIntroductionList);
            return;
        }
        updateProductIntroductionList.addAll(productIntroductionList);
    }

    private void filterProduct(List<Product> list, List<Product> saveList, List<Product> updateList) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        List<String> productCodeList = list.stream().filter(v -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)v.getProductCode())).map(Product::getProductCode).distinct().collect(Collectors.toList());
        List<Product> byProductCodes = this.productRepository.findAllListByCodeList(productCodeList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(byProductCodes)) {
            saveList.addAll(list);
            return;
        }
        Map<String, Product> codeMap = byProductCodes.stream().collect(Collectors.toMap(Product::getProductCode, v -> v, (oldValue, newValue) -> newValue));
        list.forEach(pull -> {
            Product oldEntity = (Product)((Object)((Object)codeMap.get(pull.getProductCode())));
            if (Objects.nonNull((Object)oldEntity)) {
                pull.setId(oldEntity.getId());
                pull.setCreateAccount(oldEntity.getCreateAccount());
                pull.setCreateName(oldEntity.getCreateName());
                pull.setCreateTime(oldEntity.getCreateTime());
                updateList.add((Product)((Object)pull));
            } else {
                saveList.add((Product)((Object)pull));
            }
        });
    }

    private void filterProductLevel(List<MdgProductLevelVo> list, List<MdgProductLevelVo> saveList, List<MdgProductLevelVo> updateList) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        List codeList = list.stream().filter(v -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)v.getProductLevelCode())).map(MdgProductLevelVo::getProductLevelCode).distinct().collect(Collectors.toList());
        Map codeMap = this.productLevelService.findAllListByCodeList(codeList);
        if (CollectionUtil.isEmpty((Map)codeMap)) {
            saveList.addAll(list);
            return;
        }
        list.forEach(pull -> {
            String id = (String)codeMap.get(pull.getProductLevelCode());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)id)) {
                pull.setId(id);
                updateList.add((MdgProductLevelVo)pull);
            } else {
                saveList.add((MdgProductLevelVo)pull);
            }
        });
    }

    private void filterProductBrand(List<ProductBrandVo> list, List<ProductBrandVo> saveList, List<ProductBrandVo> updateList) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        List codeList = list.stream().filter(v -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)v.getProductBrandCode())).map(ProductBrandVo::getProductBrandCode).distinct().collect(Collectors.toList());
        Map codeMap = this.productBrandService.findAllListByCodeList(codeList);
        if (CollectionUtil.isEmpty((Map)codeMap)) {
            saveList.addAll(list);
            return;
        }
        list.forEach(pull -> {
            String id = (String)codeMap.get(pull.getProductBrandCode());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)id)) {
                pull.setId(id);
                updateList.add((ProductBrandVo)pull);
            } else {
                saveList.add((ProductBrandVo)pull);
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdateBatch(List<Product> saveList, List<Product> updateList, List<MdgProductLevelVo> saveProductLevelList, List<MdgProductLevelVo> updateProductLevelList, List<ProductBrandVo> saveProductBrandList, List<ProductBrandVo> updateProductBrandList) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(saveList)) {
            this.productRepository.saveBatch(saveList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(updateList)) {
            this.productRepository.updateBatchById(updateList);
        }
        this.productLevelService.saveOrUpdateBatch(saveProductLevelList, updateProductLevelList);
        this.productBrandService.saveOrUpdateBatch(saveProductBrandList, updateProductBrandList);
    }

    private void unLock(String yearMonthDay) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u62c9\u53d6\u7269\u6599\u89e3\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.redisMutexService.unlock("material_lock:lock:" + yearMonthDay);
    }

    private List<Product> materialValidate(List<MasterDataMdgMaterialVo> masterDataMdgMaterialVos, List<MdgProductLevelVo> productLevelList, List<ProductBrandVo> productBrandList, Set<String> codeSet, Set<String> productBrandCodeSet, Set<String> productLevelCodeSet, Map<String, Set<String>> businessFormatBrandMap) {
        ArrayList<Product> pullList = new ArrayList<Product>();
        String tenantCode = TenantUtils.getTenantCode();
        for (MasterDataMdgMaterialVo masterDataMdgSupplierBankVo : masterDataMdgMaterialVos) {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)masterDataMdgSupplierBankVo.getMatnr())) {
                log.error("\u672c\u6b21\u62c9\u53d6\u6570\u636e\u7269\u6599\u7f16\u7801\u4e3a\u7a7a" + masterDataMdgMaterialVos);
                throw new RuntimeException("\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (codeSet.contains(masterDataMdgSupplierBankVo.getMatnr())) {
                log.error("\u672c\u6b21\u62c9\u53d6\u6570\u636e\u7269\u6599\u7f16\u7801\u91cd\u590d" + masterDataMdgMaterialVos);
                throw new RuntimeException("\u7f16\u7801" + masterDataMdgSupplierBankVo.getMatnr() + "\u91cd\u590d\u62c9\u53d6\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            codeSet.add(masterDataMdgSupplierBankVo.getMatnr());
            Product product = this.setProductData(tenantCode, productBrandCodeSet, productLevelCodeSet, productLevelList, productBrandList, masterDataMdgSupplierBankVo, businessFormatBrandMap);
            pullList.add(product);
        }
        return pullList;
    }

    private boolean lock(String yearMonthDay) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u62c9\u53d6\u7269\u6599\u52a0\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.redisMutexService.tryLock("material_lock:lock:" + yearMonthDay, TimeUnit.HOURS, 12);
    }

    private void createValidation(Product product) {
        this.validation(product);
    }

    private void updateValidation(Product product) {
        Validate.notNull((Object)((Object)product), (String)"\u5546\u54c1\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)product.getId()), (String)"\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validation(product);
    }

    private void validation(Product product) {
        Validate.notNull((Object)((Object)product), (String)"\u5546\u54c1\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)product.getProductCode()), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)product.getProductName()), (String)"\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

