/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.mdm.business.product.local.entity.ProductUnit;
import com.biz.crm.mdm.business.product.local.repository.ProductUnitRepository;
import com.biz.crm.mdm.business.product.local.service.ProductUnitService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="productUnitService")
public class ProductUnitServiceImpl
implements ProductUnitService {
    private static final Logger log = LoggerFactory.getLogger(ProductUnitServiceImpl.class);
    @Autowired
    private ProductUnitRepository productUnitRepository;

    @Override
    public ProductUnit findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (ProductUnit)((Object)this.productUnitRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public ProductUnit create(ProductUnit productUnit) {
        this.createValidate(productUnit);
        this.productUnitRepository.saveOrUpdate((Object)productUnit);
        return productUnit;
    }

    @Override
    public void saveBatch(List<ProductUnit> productUnits) {
        if (CollectionUtils.isEmpty(productUnits)) {
            return;
        }
        List productCodes = productUnits.stream().map(ProductUnit::getProductCode).collect(Collectors.toList());
        LambdaQueryWrapper lq = Wrappers.lambdaQuery();
        this.productUnitRepository.remove((Wrapper)lq.in(ProductUnit::getProductCode, productCodes));
        this.productUnitRepository.saveBatch(productUnits);
    }

    @Override
    @Transactional
    public ProductUnit update(ProductUnit productUnit) {
        this.updateValidate(productUnit);
        this.productUnitRepository.saveOrUpdate((Object)productUnit);
        return productUnit;
    }

    @Override
    public List<ProductUnit> findByProductCodes(ArrayList<String> newArrayList) {
        return ((LambdaQueryChainWrapper)this.productUnitRepository.lambdaQuery().in(ProductUnit::getProductCode, newArrayList)).list();
    }

    private void createValidate(ProductUnit productUnit) {
        Validate.notNull((Object)((Object)productUnit), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        productUnit.setId(null);
        Validate.notBlank((CharSequence)productUnit.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ProductUnit one = (ProductUnit)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.productUnitRepository.lambdaQuery().eq(ProductUnit::getProductCode, (Object)productUnit.getProductCode())).eq(ProductUnit::getUnitCode, (Object)productUnit.getProductCode())).one());
        Validate.isTrue((boolean)ObjectUtils.isEmpty((Object)((Object)one)), (String)"\u5bf9\u5e94\u5355\u4f4d\u5df2\u5b58\u5728", (Object[])new Object[0]);
    }

    private void updateValidate(ProductUnit productUnit) {
        Validate.notNull((Object)((Object)productUnit), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productUnit.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productUnit.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

