/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.biz.crm.mdm.business.product.level.sdk.dto.RelateProductLevelCodeQueryDto;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.local.entity.Product;
import com.biz.crm.mdm.business.product.local.entity.ProductIntroduction;
import com.biz.crm.mdm.business.product.local.entity.ProductMaterial;
import com.biz.crm.mdm.business.product.local.entity.ProductMedia;
import com.biz.crm.mdm.business.product.local.entity.ProductUnit;
import com.biz.crm.mdm.business.product.local.repository.ProductRepository;
import com.biz.crm.mdm.business.product.local.service.ProductIntroductionService;
import com.biz.crm.mdm.business.product.local.service.ProductMaterialService;
import com.biz.crm.mdm.business.product.local.service.ProductMediaService;
import com.biz.crm.mdm.business.product.local.service.ProductService;
import com.biz.crm.mdm.business.product.local.service.ProductUnitService;
import com.biz.crm.mdm.business.product.local.strategy.DisplayProductStrategy;
import com.biz.crm.mdm.business.product.sdk.dto.DisplayProductDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductCodeUnitGroup;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDetailQueryDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductEventDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductLevelUnitsGroup;
import com.biz.crm.mdm.business.product.sdk.dto.ProductMaterialDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductMediaDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductPaginationDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductSynchronousUpdateDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductUnitDto;
import com.biz.crm.mdm.business.product.sdk.enums.IsShelfEnum;
import com.biz.crm.mdm.business.product.sdk.enums.MediaTypeEnum;
import com.biz.crm.mdm.business.product.sdk.enums.ProductExtInfoTypeEnum;
import com.biz.crm.mdm.business.product.sdk.event.ProductEventListener;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.DisplayProductVo;
import com.biz.crm.mdm.business.product.sdk.vo.MaterialProductVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductIntroductionVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductMaterialVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductMediaVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductPlanningDetailsVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductUnitVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="productVoService")
public class ProductVoServiceImpl
implements ProductVoService {
    private static final Logger log = LoggerFactory.getLogger(ProductVoServiceImpl.class);
    @Autowired(required=false)
    private ProductService productService;
    @Autowired(required=false)
    private ProductMaterialService productMaterialService;
    @Autowired(required=false)
    private ProductMediaService productMediaService;
    @Autowired(required=false)
    private ProductIntroductionService productIntroductionService;
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required=false)
    private MaterialVoService materialVoService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private ProductRepository productRepository;
    @Autowired(required=false)
    private ProductUnitService productUnitService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private DisplayProductStrategy displayProductStrategy;

    @Transactional
    public ProductVo create(ProductDto dto) {
        this.createValidation(dto);
        Product product = this.buildProductByDto(dto);
        dto.setProductCode(product.getProductCode());
        product.setTenantCode(TenantUtils.getTenantCode());
        this.bindProductExtInfo(dto);
        this.productService.create(product);
        ProductEventDto productEventDto = new ProductEventDto();
        productEventDto.setOriginal(null);
        ProductVo productVo = (ProductVo)this.nebulaToolkitService.copyObjectByBlankList((Object)product, ProductVo.class, HashSet.class, LinkedList.class, new String[0]);
        productEventDto.setNewest(productVo);
        SerializableBiConsumer & Serializable onCreate = ProductEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)productEventDto, ProductEventListener.class, (SerializableBiConsumer)onCreate);
        return this.buildByDtoAndProduct(dto, product);
    }

    @Transactional
    public ProductVo update(ProductDto dto) {
        this.updateValidation(dto);
        List<ProductVo> current = this.findDetailsByIdsOrProductCodes(Collections.singletonList(dto.getId()), null);
        ProductVo current2 = current.stream().findFirst().orElse(null);
        Validate.notNull((Object)current2, (String)"\u672a\u83b7\u53d6\u5230\u4fee\u6539\u7684\u5546\u54c1\u4fe1\u606f", (Object[])new Object[0]);
        ProductVo productVo = (ProductVo)this.nebulaToolkitService.copyObjectByBlankList((Object)current2, ProductVo.class, HashSet.class, LinkedList.class, new String[0]);
        Product product = this.buildProductByDto(dto);
        this.bindProductExtInfo(dto);
        product.setTenantCode(TenantUtils.getTenantCode());
        this.productService.update(product);
        ProductEventDto productEventDto = new ProductEventDto();
        productEventDto.setOriginal(productVo);
        ProductVo productVo2 = (ProductVo)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, ProductVo.class, HashSet.class, LinkedList.class, new String[0]);
        productEventDto.setNewest(productVo2);
        return this.buildByDtoAndProduct(dto, product);
    }

    public List<ProductVo> findSelectByKeyword(String keyword) {
        PageRequest pageable = PageRequest.of((int)0, (int)20);
        ProductPaginationDto dto = new ProductPaginationDto();
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setKeyword(keyword);
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<Product> pageResult = this.productRepository.findByConditions((Page<Product>)page, dto);
        if (Objects.isNull(pageResult) || CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return Lists.newLinkedList();
        }
        ArrayList list = Lists.newArrayList();
        for (Product item : pageResult.getRecords()) {
            ProductVo cur = new ProductVo();
            cur.setProductCode(item.getProductCode());
            cur.setProductName(item.getProductName());
            list.add(cur);
        }
        return list;
    }

    public MaterialProductVo findMaterialProductVoByMaterialCode(String materialCode) {
        if (StringUtils.isBlank((CharSequence)materialCode)) {
            return null;
        }
        Set<String> productCodeSet = this.productMaterialService.findProductCodeByMaterialCode(materialCode);
        if (CollectionUtils.isEmpty(productCodeSet)) {
            return null;
        }
        MaterialProductVo re = new MaterialProductVo();
        re.setProductCodeSet(productCodeSet);
        Set<String> productParentLevelCodeSet = this.findParentLevelCodeSetByProductCodes(productCodeSet);
        re.setProductLevelCodeSet(productParentLevelCodeSet);
        return re;
    }

    public List<ProductVo> findByProductLevelCodes(List<String> productLevelCodeList) {
        if (CollectionUtils.isEmpty(productLevelCodeList)) {
            return Lists.newLinkedList();
        }
        List<ProductVo> productVos = this.productRepository.findByProductLevelCodes(productLevelCodeList);
        if (CollectionUtils.isEmpty(productVos)) {
            return Lists.newLinkedList();
        }
        return this.findDetailsByIdsOrProductCodes(null, productVos.stream().map(ProductVo::getProductCode).collect(Collectors.toList()));
    }

    public Set<String> findParentLevelCodeSetByProductCodes(Set<String> productCodeSet) {
        if (CollectionUtils.isEmpty(productCodeSet)) {
            return Sets.newHashSet();
        }
        Set<String> productLevelCodeSet = this.productService.findProductLevelCodeSetByProductCodes(productCodeSet);
        if (CollectionUtils.isEmpty(productLevelCodeSet)) {
            return Sets.newHashSet();
        }
        Map map = this.productLevelVoSdkService.findCurAndParentByCodes((List)Lists.newArrayList(productLevelCodeSet));
        if (map.isEmpty()) {
            return Sets.newHashSet();
        }
        HashSet re = Sets.newHashSet();
        for (Map.Entry item : map.entrySet()) {
            for (ProductLevelVo sub : (List)item.getValue()) {
                re.add(sub.getProductLevelCode());
            }
        }
        return re;
    }

    public List<ProductVo> findByProductQueryDto(ProductQueryDto dto) {
        Boolean f = Objects.isNull(dto) || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{dto.getProductCode(), dto.getProductName(), dto.getProductName(), dto.getIsShelf(), dto.getEnableStatus()}) && CollectionUtils.isEmpty((Collection)dto.getProductLevelCodeList()) && CollectionUtils.isEmpty((Collection)dto.getProductCodeList());
        if (Boolean.TRUE.equals(f)) {
            return Lists.newLinkedList();
        }
        List<Product> list = this.productRepository.findByProductQueryDto(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(list, Product.class, ProductVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<ProductVo> findByQueryDto(ProductQueryDto dto) {
        return super.findByQueryDto(dto);
    }

    public List<ProductVo> findDetailsByIdsOrProductCodes(List<String> ids, List<String> productCodes) {
        if (CollectionUtils.isEmpty(ids) && CollectionUtils.isEmpty(productCodes)) {
            return Lists.newLinkedList();
        }
        ProductDetailQueryDto dto = new ProductDetailQueryDto();
        dto.setExInfoCodes(ProductExtInfoTypeEnum.findAllKey());
        if (CollectionUtils.isNotEmpty(ids)) {
            dto.setCodeQueryFlag(Boolean.valueOf(false));
            dto.setCodes(ids);
        } else if (CollectionUtils.isNotEmpty(productCodes)) {
            dto.setCodeQueryFlag(Boolean.valueOf(true));
            dto.setCodes(productCodes);
        }
        return this.findDetailsByProductDetailQueryDto(dto);
    }

    public List<ProductVo> findDetailsByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newLinkedList();
        }
        ProductDetailQueryDto dto = new ProductDetailQueryDto();
        dto.setExInfoCodes(ProductExtInfoTypeEnum.findAllKey());
        dto.setCodeQueryFlag(Boolean.valueOf(false));
        dto.setCodes(ids);
        return this.findDetailsByProductDetailQueryDto(dto);
    }

    public List<ProductVo> findDetailsByProductCodes(List<String> productCodes) {
        if (CollectionUtils.isEmpty(productCodes)) {
            return Lists.newLinkedList();
        }
        ProductDetailQueryDto dto = new ProductDetailQueryDto();
        dto.setExInfoCodes(ProductExtInfoTypeEnum.findAllKey());
        dto.setCodeQueryFlag(Boolean.valueOf(true));
        dto.setCodes(productCodes);
        return this.findDetailsByProductDetailQueryDto(dto);
    }

    public List<ProductVo> findByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List<Product> productList = this.productRepository.findByCodes(codes);
        if (CollectionUtils.isEmpty(productList)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(productList, Product.class, ProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<ProductVo> findByProductCodes(List<String> productCodes) {
        if (CollectionUtils.isEmpty(productCodes)) {
            return Lists.newLinkedList();
        }
        ProductDetailQueryDto dto = new ProductDetailQueryDto();
        dto.setExInfoCodes(ProductExtInfoTypeEnum.findAllKey());
        dto.setCodeQueryFlag(Boolean.valueOf(true));
        dto.setCodes(productCodes);
        return this.findDetailsByProductDetailQueryDto(dto);
    }

    public List<ProductVo> findMainDetailsByProductCodes(List<String> productCodeList) {
        if (CollectionUtils.isEmpty(productCodeList)) {
            return Lists.newLinkedList();
        }
        ProductDetailQueryDto dto = new ProductDetailQueryDto();
        dto.setExInfoCodes((Set)Sets.newHashSet((Object[])new String[]{ProductExtInfoTypeEnum.PRODUCT_LEVEL.getDictCode()}));
        dto.setCodeQueryFlag(Boolean.valueOf(true));
        dto.setCodes(productCodeList);
        return this.findDetailsByProductDetailQueryDto(dto);
    }

    public List<ProductVo> findDetailsByProductDetailQueryDto(ProductDetailQueryDto dto) {
        if (Objects.isNull(dto) || CollectionUtils.isEmpty((Collection)dto.getCodes())) {
            return Lists.newLinkedList();
        }
        List ids = Lists.newLinkedList();
        List productCodes = Lists.newLinkedList();
        if (Boolean.TRUE.equals(dto.getCodeQueryFlag())) {
            productCodes = dto.getCodes();
        } else {
            ids = dto.getCodes();
        }
        List<Product> productList = this.productService.findDetailsByIdsOrProductCodes(ids, productCodes);
        if (CollectionUtils.isEmpty(productList)) {
            return Lists.newLinkedList();
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList(productList, Product.class, ProductVo.class, HashSet.class, ArrayList.class, new String[0]);
        Set<String> productCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductCode())).map(ProductVo::getProductCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty((Collection)dto.getExInfoCodes()) || CollectionUtils.isEmpty(productCodeSet)) {
            return list;
        }
        if (dto.getExInfoCodes().contains(ProductExtInfoTypeEnum.PRODUCT_LEVEL.getDictCode())) {
            this.findProductLevelInfo(list);
        }
        if (dto.getExInfoCodes().contains(ProductExtInfoTypeEnum.MATERIAL.getDictCode())) {
            this.findProductMaterialInfo(list, productCodeSet);
        }
        if (dto.getExInfoCodes().contains(ProductExtInfoTypeEnum.PICTURE.getDictCode()) || dto.getExInfoCodes().contains(ProductExtInfoTypeEnum.VIDEO.getDictCode())) {
            this.findProductMediaInfo(list, productCodeSet);
        }
        if (dto.getExInfoCodes().contains(ProductExtInfoTypeEnum.INTRO.getDictCode())) {
            this.findProductIntroInfo(list, productCodeSet);
        }
        log.info("\u67e5\u8be2\u6761\u4ef6==========" + String.join((CharSequence)",", dto.getExInfoCodes()));
        if (dto.getExInfoCodes().contains(ProductExtInfoTypeEnum.UNIT.getDictCode())) {
            this.findProductUnitInfo(list, productCodeSet);
        }
        return list;
    }

    private void findProductUnitInfo(List<ProductVo> list, Set<String> productCodeSet) {
        if (CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(productCodeSet)) {
            return;
        }
        List<ProductUnit> unitList = this.productUnitService.findByProductCodes(Lists.newArrayList(productCodeSet));
        if (CollectionUtils.isEmpty(unitList)) {
            return;
        }
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(unitList, ProductUnit.class, ProductUnitVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, List<ProductUnitVo>> listMap = voList.stream().collect(Collectors.groupingBy(ProductUnitVo::getProductCode));
        for (ProductVo item : list) {
            item.setUnitList(listMap.get(item.getProductCode()));
        }
    }

    public Map<String, String> findAllowSaleProductByProductLevelCodes(Set<String> productLevelCodes) {
        if (CollectionUtils.isEmpty(productLevelCodes)) {
            return Maps.newHashMap();
        }
        RelateProductLevelCodeQueryDto queryDto = new RelateProductLevelCodeQueryDto();
        queryDto.setProductLevelCodeSet(productLevelCodes);
        queryDto.setSearchType(Integer.valueOf(-1));
        Map productLevelRuleMap = this.productLevelVoSdkService.findByRelateProductLevelCodeQueryDto(queryDto);
        if (productLevelRuleMap.isEmpty()) {
            return Maps.newHashMap();
        }
        ProductQueryDto productQueryDto = new ProductQueryDto();
        productQueryDto.setProductLevelCodeList((List)Lists.newArrayList(productLevelCodes));
        productQueryDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        productQueryDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        productQueryDto.setIsShelf(IsShelfEnum.UP.getCode());
        productQueryDto.setTenantCode(TenantUtils.getTenantCode());
        List<ProductVo> list = this.findByProductQueryDto(productQueryDto);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Map<String, String> map = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getProductCode(), a.getProductLevelCode()}) && productLevelRuleMap.keySet().contains(a.getProductLevelCode())).collect(Collectors.toMap(ProductVo::getProductCode, ProductVo::getProductLevelCode, (a, b) -> a));
        HashMap re = Maps.newHashMap();
        for (Map.Entry<String, String> item : map.entrySet()) {
            String s = (String)productLevelRuleMap.get(item.getValue());
            if (StringUtils.isBlank((CharSequence)s)) continue;
            re.put(item.getKey(), s);
        }
        return re;
    }

    public Page<ProductVo> findByConditions(Pageable pageable, ProductPaginationDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.productRepository.findVoByConditions((Page<ProductVo>)page, dto);
    }

    public List<ProductVo> queryCondition(ProductDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newArrayList();
        }
        List<Product> productList = this.productRepository.queryCondition(dto);
        if (CollectionUtils.isEmpty(productList)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(productList, Product.class, ProductVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public ProductVo finByUnitTypeCode(String unitTypeCode) {
        if (Objects.isNull(unitTypeCode)) {
            return new ProductVo();
        }
        Product product = this.productRepository.finByUnitTypeCode(unitTypeCode);
        if (Objects.isNull((Object)product)) {
            return new ProductVo();
        }
        ProductVo productResult = (ProductVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)product, ProductVo.class, HashSet.class, ArrayList.class, new String[0]);
        return productResult;
    }

    public ProductPlanningDetailsVo findByProductPlanningDetails(String productCode, String customerCode, String businessModel, String startDate) {
        return this.productService.findByProductPlanningDetails(productCode, customerCode, businessModel, startDate);
    }

    public List<String> findAllProductCode() {
        return this.productRepository.findAllProductCode(TenantUtils.getTenantCode());
    }

    public Map<String, String> getProductByCodes(List<List<String>> codes) {
        Map<String, String> map = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(codes)) {
            return map;
        }
        List<CommonSelectVo> list = this.productRepository.getProductByCodes(codes, TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty(list)) {
            map = list.stream().collect(Collectors.toMap(CommonSelectVo::getCode, CommonSelectVo::getValue));
        }
        return map;
    }

    private void bindProductExtInfo(ProductSynchronousUpdateDto dto, String productCode) {
        Validate.notNull((Object)dto, (String)"\u5546\u54c1\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        LinkedList productMediaList = Lists.newLinkedList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getPictureMediaList())) {
            productMediaList.addAll(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getPictureMediaList(), ProductMediaDto.class, ProductMedia.class, HashSet.class, ArrayList.class, new String[0]));
            productMediaList.forEach(a -> a.setProductCode(productCode));
            productMediaList.forEach(a -> a.setTenantCode(TenantUtils.getTenantCode()));
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getVideoMediaList())) {
            productMediaList.addAll(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getVideoMediaList(), ProductMediaDto.class, ProductMedia.class, HashSet.class, ArrayList.class, new String[0]));
            productMediaList.forEach(a -> a.setProductCode(productCode));
            productMediaList.forEach(a -> a.setTenantCode(TenantUtils.getTenantCode()));
        }
        this.productMediaService.saveBatch(productMediaList, productCode);
        ProductIntroduction productIntroduction = null;
        if (Objects.nonNull(dto.getIntroduction())) {
            productIntroduction = (ProductIntroduction)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto.getIntroduction(), ProductIntroduction.class, HashSet.class, ArrayList.class, new String[0]));
            productIntroduction.setProductCode(productCode);
            productIntroduction.setTenantCode(TenantUtils.getTenantCode());
        }
        this.productIntroductionService.saveIntroduction(productIntroduction, productCode);
        LinkedList unitLinkedList = Lists.newLinkedList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getUnitList())) {
            unitLinkedList.addAll(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getUnitList(), ProductUnitDto.class, ProductUnit.class, HashSet.class, ArrayList.class, new String[0]));
            unitLinkedList.forEach(a -> {
                a.setProductCode(productCode);
                a.setTenantCode(TenantUtils.getTenantCode());
            });
            this.productUnitService.saveBatch(unitLinkedList);
        }
    }

    private void bindProductExtInfo(ProductDto dto) {
        Collection productMedia;
        Validate.notNull((Object)dto, (String)"\u5546\u54c1\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        List productMaterialList = Lists.newLinkedList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getMaterialList())) {
            productMaterialList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getMaterialList(), ProductMaterialDto.class, ProductMaterial.class, HashSet.class, ArrayList.class, new String[0]);
            productMaterialList.forEach(a -> a.setProductCode(dto.getProductCode()));
            productMaterialList.forEach(a -> a.setTenantCode(TenantUtils.getTenantCode()));
        }
        this.productMaterialService.saveBatch(productMaterialList, dto.getProductCode());
        LinkedList productMediaList = Lists.newLinkedList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getPictureMediaList())) {
            productMedia = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getPictureMediaList(), ProductMediaDto.class, ProductMedia.class, HashSet.class, ArrayList.class, new String[0]);
            productMedia.forEach(a -> a.setProductCode(dto.getProductCode()));
            productMedia.forEach(a -> a.setTenantCode(TenantUtils.getTenantCode()));
            productMedia.forEach(a -> a.setType(MediaTypeEnum.PICTURE.getCode()));
            productMediaList.addAll(productMedia);
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getMajorPictureMedia())) {
            productMedia = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getMajorPictureMedia(), ProductMediaDto.class, ProductMedia.class, HashSet.class, ArrayList.class, new String[0]);
            productMedia.forEach(a -> a.setProductCode(dto.getProductCode()));
            productMedia.forEach(a -> a.setTenantCode(TenantUtils.getTenantCode()));
            productMedia.forEach(a -> a.setType(MediaTypeEnum.MAJOR_PICTURE.getCode()));
            productMediaList.addAll(productMedia);
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getVideoMediaList())) {
            productMedia = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getVideoMediaList(), ProductMediaDto.class, ProductMedia.class, HashSet.class, ArrayList.class, new String[0]);
            productMedia.forEach(a -> a.setProductCode(dto.getProductCode()));
            productMedia.forEach(a -> a.setTenantCode(TenantUtils.getTenantCode()));
            productMedia.forEach(a -> a.setType(MediaTypeEnum.VIDEO.getCode()));
            productMediaList.addAll(productMedia);
        }
        this.productMediaService.saveBatch(productMediaList, dto.getProductCode());
        ProductIntroduction productIntroduction = null;
        if (Objects.nonNull(dto.getIntroduction())) {
            productIntroduction = (ProductIntroduction)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto.getIntroduction(), ProductIntroduction.class, HashSet.class, ArrayList.class, new String[0]));
            productIntroduction.setProductCode(dto.getProductCode());
            productIntroduction.setTenantCode(TenantUtils.getTenantCode());
        }
        this.productIntroductionService.saveIntroduction(productIntroduction, dto.getProductCode());
        LinkedList unitLinkedList = Lists.newLinkedList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getUnitList())) {
            unitLinkedList.addAll(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getUnitList(), ProductUnitDto.class, ProductUnit.class, HashSet.class, ArrayList.class, new String[0]));
            unitLinkedList.forEach(a -> {
                a.setId(null);
                a.setProductCode(dto.getProductCode());
                a.setTenantCode(TenantUtils.getTenantCode());
            });
            this.productUnitService.saveBatch(unitLinkedList);
        }
    }

    private Product buildProductByDto(ProductDto dto) {
        Product product = (Product)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, Product.class, HashSet.class, ArrayList.class, new String[0]));
        product.setMaintenancePicture(CollectionUtils.isNotEmpty((Collection)dto.getPictureMediaList()));
        product.setMaintenanceIntroduction(Objects.nonNull(dto.getIntroduction()));
        if (StringUtils.isBlank((CharSequence)product.getProductCode())) {
            String ruleCode = StringUtils.join((Object[])new String[]{"SPBM", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
            String productCode = (String)this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
            product.setProductCode(productCode);
        }
        if (CollectionUtils.isEmpty((Collection)dto.getPictureMediaList())) {
            return product;
        }
        Optional first = dto.getPictureMediaList().stream().findFirst();
        if (first.isPresent()) {
            product.setPrimaryPictureUrl(((ProductMediaDto)first.get()).getId());
        }
        return product;
    }

    private ProductVo buildByDtoAndProduct(ProductDto dto, Product product) {
        ProductVo vo = (ProductVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)product, ProductVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)dto.getMaterialList())) {
            vo.setMaterialList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getMaterialList(), ProductMaterialDto.class, ProductMaterialVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getMajorPictureMedia())) {
            vo.setMajorPictureMedia((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getMajorPictureMedia(), ProductMediaDto.class, ProductMediaVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getPictureMediaList())) {
            vo.setPictureMediaList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getPictureMediaList(), ProductMediaDto.class, ProductMediaVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getVideoMediaList())) {
            vo.setVideoMediaList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getVideoMediaList(), ProductMediaDto.class, ProductMediaVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (Objects.nonNull(dto.getIntroduction())) {
            vo.setIntroduction((ProductIntroductionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto.getIntroduction(), ProductIntroductionVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        return vo;
    }

    private void findProductLevelInfo(List<ProductVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Set productLevelCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductLevelCode())).map(ProductVo::getProductLevelCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(productLevelCodeSet)) {
            return;
        }
        List productLevelVoList = this.productLevelVoSdkService.findListByCodes((List)Lists.newArrayList(productLevelCodeSet));
        Map<String, String> mapLevel = productLevelVoList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getProductLevelCode(), a.getProductLevelName()})).collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, ProductLevelVo::getProductLevelName, (a, b) -> a));
        for (ProductVo item : list) {
            item.setProductLevelName(mapLevel.get(item.getProductLevelCode()));
        }
    }

    private void findProductMaterialInfo(List<ProductVo> list, Set<String> productCodeSet) {
        if (CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(productCodeSet)) {
            return;
        }
        List<ProductMaterial> materialList = this.productMaterialService.findByProductCodes(Lists.newArrayList(productCodeSet));
        if (CollectionUtils.isEmpty(materialList)) {
            return;
        }
        Set materialCodes = materialList.stream().map(ProductMaterial::getMaterialCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(materialCodes)) {
            return;
        }
        List materialVoList = this.materialVoService.findDetailByMaterialCodes(materialCodes);
        if (CollectionUtils.isEmpty((Collection)materialVoList)) {
            return;
        }
        Map map = materialVoList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getMaterialCode())).collect(Collectors.toMap(MaterialVo::getMaterialCode, Function.identity(), (a, b) -> a));
        List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(materialList, ProductMaterial.class, ProductMaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (ProductMaterialVo v : voList) {
            if (!map.containsKey(v.getMaterialCode())) continue;
            MaterialVo materialVo = (MaterialVo)map.get(v.getMaterialCode());
            v.setProductLevelCode(materialVo.getProductLevelCode());
            v.setProductLevelName(materialVo.getProductLevelName());
            v.setMaterialType(materialVo.getMaterialType());
            v.setMaterialTypeName(materialVo.getMaterialTypeName());
            v.setUnitTypeCode(materialVo.getUnitTypeCode());
        }
        Map<String, List<ProductMaterialVo>> mapProductMaterial = voList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductCode())).collect(Collectors.groupingBy(ProductMaterialVo::getProductCode));
        for (ProductVo item : list) {
            item.setMaterialList(mapProductMaterial.get(item.getProductCode()));
        }
    }

    private void findProductMediaInfo(List<ProductVo> list, Set<String> productCodeSet) {
        if (CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(productCodeSet)) {
            return;
        }
        List<ProductMedia> mediaList = this.productMediaService.findByProductCodes(Lists.newArrayList(productCodeSet));
        if (CollectionUtils.isEmpty(mediaList)) {
            return;
        }
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(mediaList, ProductMedia.class, ProductMediaVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, List<ProductMediaVo>> map = voList.stream().collect(Collectors.groupingBy(ProductMediaVo::getType));
        Map<String, List<ProductMediaVo>> mapPictureMedia = map.getOrDefault(MediaTypeEnum.PICTURE.getCode(), Lists.newArrayList()).stream().collect(Collectors.groupingBy(ProductMediaVo::getProductCode));
        Map<String, List<ProductMediaVo>> mapVideoMedia = map.getOrDefault(MediaTypeEnum.VIDEO.getCode(), Lists.newArrayList()).stream().collect(Collectors.groupingBy(ProductMediaVo::getProductCode));
        Map<String, List<ProductMediaVo>> mapmajotMedia = map.getOrDefault(MediaTypeEnum.MAJOR_PICTURE.getCode(), Lists.newArrayList()).stream().collect(Collectors.groupingBy(ProductMediaVo::getProductCode));
        for (ProductVo item : list) {
            item.setPictureMediaList(mapPictureMedia.get(item.getProductCode()));
            item.setVideoMediaList(mapVideoMedia.get(item.getProductCode()));
            item.setMajorPictureMedia(mapmajotMedia.get(item.getProductCode()));
        }
    }

    private void findProductIntroInfo(List<ProductVo> list, Set<String> productCodeSet) {
        if (CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(productCodeSet)) {
            return;
        }
        List<ProductIntroduction> introductionList = this.productIntroductionService.findByProductCodes(Lists.newArrayList(productCodeSet));
        if (CollectionUtils.isEmpty(introductionList)) {
            return;
        }
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(introductionList, ProductIntroduction.class, ProductIntroductionVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map map = voList.stream().collect(Collectors.toMap(ProductIntroductionVo::getProductCode, Function.identity(), (a, b) -> a));
        for (ProductVo item : list) {
            item.setIntroduction((ProductIntroductionVo)map.get(item.getProductCode()));
        }
    }

    private void createValidation(ProductDto dto) {
        this.validation(dto);
    }

    private void updateValidation(ProductDto dto) {
        Validate.notNull((Object)dto, (String)"\u5546\u54c1\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getId()), (String)"\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validation(dto);
    }

    private void updateValidation(ProductSynchronousUpdateDto dto) {
        Validate.notNull((Object)dto, (String)"\u5546\u54c1\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getId()), (String)"\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void validation(ProductDto dto) {
        Validate.notNull((Object)dto, (String)"\u5546\u54c1\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)dto.getProductCode())) {
            Product byProductCode = this.productService.findByProductCode(dto.getProductCode());
            Validate.isTrue((Objects.isNull((Object)byProductCode) || (StringUtils.isNotBlank((CharSequence)dto.getId()) ? dto.getId().equals(byProductCode.getId()) : Objects.isNull((Object)byProductCode)) ? 1 : 0) != 0, (String)"\u5546\u54c1\u7f16\u7801\u91cd\u590d", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)dto.getProductName(), (String)"\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    public Map<String, String> findNameByIdsOrCodes(List<String> ids, List<String> productCodes) {
        return this.productRepository.findNameByIdsOrCodes(ids, productCodes);
    }

    public ProductVo updateSynchronous(ProductSynchronousUpdateDto dto) {
        this.updateValidation(dto);
        Product product = this.productRepository.findById(dto.getId());
        Validate.notNull((Object)((Object)product), (String)"\u672a\u83b7\u53d6\u5230\u4fee\u6539\u7684\u5546\u54c1\u4fe1\u606f", (Object[])new Object[0]);
        List<ProductVo> current = this.findDetailsByIdsOrProductCodes(null, Collections.singletonList(product.getProductCode()));
        ProductVo current2 = current.stream().findFirst().orElse(null);
        Validate.notNull((Object)current2, (String)"\u672a\u83b7\u53d6\u5230\u4fee\u6539\u7684\u5546\u54c1\u4fe1\u606f", (Object[])new Object[0]);
        ProductVo productVo = (ProductVo)this.nebulaToolkitService.copyObjectByBlankList((Object)current2, ProductVo.class, HashSet.class, LinkedList.class, new String[0]);
        this.bindProductExtInfo(dto, productVo.getProductCode());
        BeanUtils.copyProperties((Object)dto, (Object)((Object)product));
        this.productService.update(product);
        ProductEventDto productEventDto = new ProductEventDto();
        productEventDto.setOriginal(productVo);
        ProductVo productVo2 = (ProductVo)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, ProductVo.class, HashSet.class, LinkedList.class, new String[0]);
        productEventDto.setNewest(productVo2);
        SerializableBiConsumer & Serializable onUpdate = ProductEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)productEventDto, ProductEventListener.class, (SerializableBiConsumer)onUpdate);
        return null;
    }

    public List<DisplayProductVo> findPackageDescOrBrandOrgOrCategory(DisplayProductDto displayProductDto) {
        ArrayList displayProductVoList = Lists.newArrayList();
        if (displayProductDto.getType().length == 1) {
            List<DisplayProductVo> productInfos = this.findProductInfosOnce(displayProductDto);
            if (CollectionUtils.isEmpty(productInfos)) {
                return null;
            }
            displayProductVoList.addAll(productInfos);
        } else if (displayProductDto.getType().length > 1) {
            List<DisplayProductVo> productInfos = this.findProductInfosTwo(displayProductDto);
            if (CollectionUtils.isEmpty(productInfos)) {
                return null;
            }
            displayProductVoList.addAll(productInfos);
        } else {
            List<DisplayProductVo> productInfos = this.findProductInfosThree(displayProductDto);
            if (CollectionUtils.isEmpty(productInfos)) {
                return null;
            }
            displayProductVoList.addAll(productInfos);
        }
        return displayProductVoList;
    }

    private List<DisplayProductVo> findProductInfosThree(DisplayProductDto displayProductDto) {
        String brandOrg = displayProductDto.getBrandOrg();
        String productCategoryCode = displayProductDto.getProductCategoryCode();
        String packageDesc = displayProductDto.getPackageDesc();
        ArrayList result = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)brandOrg) && StringUtils.isNotEmpty((CharSequence)productCategoryCode) && StringUtils.isEmpty((CharSequence)packageDesc)) {
            List<DisplayProductVo> packageDescList = this.displayProductStrategy.findPackageDesc(displayProductDto);
            if (CollectionUtils.isEmpty(packageDescList)) {
                return null;
            }
            result.addAll(packageDescList);
        }
        if (StringUtils.isNotEmpty((CharSequence)brandOrg) && StringUtils.isNotEmpty((CharSequence)packageDesc) && StringUtils.isEmpty((CharSequence)productCategoryCode)) {
            List<DisplayProductVo> categoryList = this.displayProductStrategy.findCategoryName(displayProductDto);
            if (CollectionUtils.isEmpty(categoryList)) {
                return null;
            }
            result.addAll(categoryList);
        }
        if (StringUtils.isNotEmpty((CharSequence)packageDesc) && StringUtils.isNotEmpty((CharSequence)productCategoryCode) && StringUtils.isEmpty((CharSequence)brandOrg)) {
            List<DisplayProductVo> brandOrgList = this.displayProductStrategy.findBrandOrg(displayProductDto);
            if (CollectionUtils.isEmpty(brandOrgList)) {
                return null;
            }
            result.addAll(brandOrgList);
        }
        return result;
    }

    private List<DisplayProductVo> findProductInfosTwo(DisplayProductDto dto) {
        Validate.notNull((Object)dto.getType(), (String)"\u4e8c\u6b21\u67e5\u8be2\u4ea7\u54c1\u4fe1\u606f\u65f6\uff0ctype\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        DisplayProductDto displayProductDto = new DisplayProductDto();
        displayProductDto.setType(dto.getType());
        ArrayList result = Lists.newArrayList();
        for (String type : displayProductDto.getType()) {
            List<DisplayProductVo> categoryNameList;
            List<DisplayProductVo> brandOrgList;
            List<DisplayProductVo> packageDescList;
            if (type.equals("BrandOrgProductCategory")) {
                displayProductDto.setBrandOrg(dto.getBrandOrg());
                Validate.notNull((Object)displayProductDto.getBrandOrg(), (String)"\u9009\u62e9\u54c1\u7c7b\u540d\u79f0\u65f6\u54c1\u724c\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                List<DisplayProductVo> categories = this.displayProductStrategy.findCategoryName(displayProductDto);
                if (CollectionUtils.isEmpty(categories)) {
                    return null;
                }
                result.addAll(categories);
            }
            if (type.equals("BrandOrgPackageDesc")) {
                displayProductDto.setBrandOrg(dto.getBrandOrg());
                Validate.notNull((Object)displayProductDto.getBrandOrg(), (String)"\u9009\u62e9\u7269\u6599\u5305\u88c5\u7269\u6599\u65f6\u54c1\u724c\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                packageDescList = this.displayProductStrategy.findPackageDesc(displayProductDto);
                if (CollectionUtils.isEmpty(packageDescList)) {
                    return null;
                }
                result.addAll(packageDescList);
            }
            if (type.equals("ProductCategoryBrandOrg")) {
                displayProductDto.setProductCategoryCode(dto.getProductCategoryCode());
                Validate.notNull((Object)displayProductDto.getProductCategoryCode(), (String)"\u9009\u62e9\u54c1\u724c\u7ec4\u65f6\u54c1\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                brandOrgList = this.displayProductStrategy.findBrandOrg(displayProductDto);
                if (CollectionUtils.isEmpty(brandOrgList)) {
                    return null;
                }
                result.addAll(brandOrgList);
            }
            if (type.equals("ProductCategoryPackageDesc")) {
                displayProductDto.setProductCategoryCode(dto.getProductCategoryCode());
                Validate.notNull((Object)displayProductDto.getProductCategoryCode(), (String)"\u9009\u62e9\u7269\u6599\u5305\u88c5\u7269\u6599\u65f6\u54c1\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                packageDescList = this.displayProductStrategy.findPackageDesc(displayProductDto);
                if (CollectionUtils.isEmpty(packageDescList)) {
                    return null;
                }
                result.addAll(packageDescList);
            }
            if (type.equals("PackageDescBrandOrg")) {
                displayProductDto.setPackageDesc(dto.getPackageDesc());
                Validate.notNull((Object)displayProductDto.getPackageDesc(), (String)"\u9009\u62e9\u54c1\u724c\u7ec4\u65f6\u7269\u6599\u5305\u88c5\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                brandOrgList = this.displayProductStrategy.findBrandOrg(displayProductDto);
                if (CollectionUtils.isEmpty(brandOrgList)) {
                    return null;
                }
                result.addAll(brandOrgList);
            }
            if (!type.equals("PackageDescProductCategory")) continue;
            if (StringUtils.isEmpty((CharSequence)displayProductDto.getPackageDesc())) {
                displayProductDto.setPackageDesc(dto.getPackageDesc());
                Validate.notNull((Object)displayProductDto.getPackageDesc(), (String)"\u9009\u62e9\u54c1\u7c7b\u540d\u79f0\u65f6\u7269\u6599\u5305\u88c5\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            }
            if (CollectionUtils.isEmpty(categoryNameList = this.displayProductStrategy.findCategoryName(displayProductDto))) {
                return null;
            }
            result.addAll(categoryNameList);
        }
        return result;
    }

    private List<DisplayProductVo> findProductInfosOnce(DisplayProductDto dto) {
        Validate.notNull((Object)dto.getType(), (String)"\u9996\u6b21\u67e5\u8be2\u4ea7\u54c1\u4fe1\u606f\u65f6\uff0ctype\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        DisplayProductDto displayProductDto = new DisplayProductDto();
        displayProductDto.setType(dto.getType());
        ArrayList result = Lists.newArrayList();
        for (String type : displayProductDto.getType()) {
            if (type.equals("BrandOrg")) {
                List<DisplayProductVo> brandOrgList = this.displayProductStrategy.findBrandOrg(displayProductDto);
                if (CollectionUtils.isEmpty(brandOrgList)) {
                    return null;
                }
                result.addAll(brandOrgList);
                continue;
            }
            if (type.equals("ProductCategory")) {
                List<DisplayProductVo> categoryList = this.displayProductStrategy.findCategoryName(displayProductDto);
                if (CollectionUtils.isEmpty(categoryList)) {
                    return null;
                }
                result.addAll(categoryList);
                continue;
            }
            if (!type.equals("PackageDesc")) continue;
            List<DisplayProductVo> packageDescList = this.displayProductStrategy.findPackageDesc(displayProductDto);
            if (CollectionUtils.isEmpty(packageDescList)) {
                return null;
            }
            result.addAll(packageDescList);
        }
        return result;
    }

    public ProductVo findByCode(String productCode, Boolean enableStatusFlag) {
        return this.productRepository.findByCode(productCode, enableStatusFlag);
    }

    public Boolean validProductGroupUnion(List<ProductCodeUnitGroup> productCodeUnitGroups, List<ProductLevelUnitsGroup> productLevelUnitsGroups) {
        return null;
    }
}

