/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.local.strategy;

import com.biz.crm.mdm.business.product.local.entity.Product;
import com.biz.crm.mdm.business.product.local.repository.ProductRepository;
import com.biz.crm.mdm.business.product.local.strategy.DisplayProductStrategy;
import com.biz.crm.mdm.business.product.sdk.dto.DisplayProductDto;
import com.biz.crm.mdm.business.product.sdk.vo.DisplayProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DisplayProductStrategyImpl
implements DisplayProductStrategy {
    @Autowired(required=false)
    private ProductRepository productRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public List<DisplayProductVo> findCategoryName(DisplayProductDto displayProductDto) {
        List<DisplayProductVo> categoryList = this.findCategoryByPackageDescOrBrandOrges(displayProductDto);
        if (CollectionUtils.isEmpty(categoryList)) {
            return null;
        }
        return categoryList;
    }

    @Override
    public List<DisplayProductVo> findPackageDesc(DisplayProductDto displayProductDto) {
        List<DisplayProductVo> packageDescList = this.findPackageDescByCategoryOrBrandOrg(displayProductDto);
        if (CollectionUtils.isEmpty(packageDescList)) {
            return null;
        }
        return packageDescList;
    }

    @Override
    public List<DisplayProductVo> findBrandOrg(DisplayProductDto displayProductDto) {
        List<DisplayProductVo> brandOrgList = this.findBrandOrgByCategoryOrPackageDesc(displayProductDto);
        if (CollectionUtils.isEmpty(brandOrgList)) {
            return null;
        }
        return brandOrgList;
    }

    private List<DisplayProductVo> findCategoryByPackageDescOrBrandOrges(DisplayProductDto displayProductDto) {
        List<Product> productList = this.productRepository.findPackageDescOrBrandOrgOrCategory(displayProductDto);
        if (CollectionUtils.isEmpty(productList)) {
            return null;
        }
        productList.removeAll(Collections.singleton(null));
        List displayProducts = (List)this.nebulaToolkitService.copyCollectionByWhiteList(productList, Product.class, DisplayProductVo.class, HashSet.class, ArrayList.class, new String[0]);
        List itemList = displayProducts.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DisplayProductVo>(Comparator.comparing(DisplayProductVo::getProductCategoryCode))), ArrayList::new));
        if (CollectionUtils.isEmpty((Collection)itemList)) {
            return null;
        }
        ArrayList<DisplayProductVo> displayProductVos = new ArrayList<DisplayProductVo>(itemList.size());
        itemList.stream().forEach(i -> {
            DisplayProductVo displayProductVo = new DisplayProductVo();
            displayProductVo.setProductCategoryCode(i.getProductCategoryCode());
            displayProductVo.setProductCategoryName(i.getProductCategoryName());
            displayProductVos.add(displayProductVo);
        });
        return displayProductVos;
    }

    private List<DisplayProductVo> findPackageDescByCategoryOrBrandOrg(DisplayProductDto displayProductDto) {
        List<Product> productList = this.productRepository.findPackageDescOrBrandOrgOrCategory(displayProductDto);
        if (CollectionUtils.isEmpty(productList)) {
            return null;
        }
        productList.removeAll(Collections.singleton(null));
        List packageDescList = productList.stream().filter(p -> p.getPackageDesc() != null).map(p -> p.getPackageDesc()).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(packageDescList)) {
            return null;
        }
        ArrayList<DisplayProductVo> displayProductVos = new ArrayList<DisplayProductVo>(packageDescList.size());
        packageDescList.stream().forEach(p -> {
            DisplayProductVo displayProductVo = new DisplayProductVo();
            displayProductVo.setPackageDesc(p);
            displayProductVos.add(displayProductVo);
        });
        return displayProductVos;
    }

    private List<DisplayProductVo> findBrandOrgByCategoryOrPackageDesc(DisplayProductDto displayProductDto) {
        List<Product> productList = this.productRepository.findPackageDescOrBrandOrgOrCategory(displayProductDto);
        if (CollectionUtils.isEmpty(productList)) {
            return null;
        }
        productList.removeAll(Collections.singleton(null));
        List brandOrgList = productList.stream().filter(p -> StringUtils.isNotEmpty((CharSequence)p.getBrandOrg())).map(p -> p.getBrandOrg()).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(brandOrgList)) {
            return null;
        }
        ArrayList<DisplayProductVo> displayProductVos = new ArrayList<DisplayProductVo>(brandOrgList.size());
        brandOrgList.stream().forEach(b -> {
            DisplayProductVo displayProductVo = new DisplayProductVo();
            displayProductVo.setBrandOrg(b);
            displayProductVos.add(displayProductVo);
        });
        return displayProductVos;
    }
}

