package com.biz.crm.mdm.business.product.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.product.local.entity.ProductIntroduction;
import com.biz.crm.mdm.business.product.local.mapper.ProductIntroductionMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 商品富文本(repository)
 *
 * @author sunx
 * @since 2021-10-14 16:06:25
 */
@Component
public class ProductIntroductionRepository
    extends ServiceImpl<ProductIntroductionMapper, ProductIntroduction> {

  public List<ProductIntroduction> findByProductCodes(List<String> productCodeList) {
    return lambdaQuery()
        .eq(ProductIntroduction::getTenantCode, TenantUtils.getTenantCode())
        .in(ProductIntroduction::getProductCode, productCodeList)
        .list();
  }

  public void deleteByProductCode(String productCode) {
    LambdaQueryWrapper<ProductIntroduction> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery
        .eq(ProductIntroduction::getTenantCode, TenantUtils.getTenantCode())
        .eq(ProductIntroduction::getProductCode, productCode);
    baseMapper.delete(lambdaQuery);
  }
}
