package com.biz.crm.mdm.business.product.local.service;

import com.biz.crm.mdm.business.product.local.entity.ProductIntroduction;
import java.util.List;

/**
 * 商品富文本介绍信息
 *
 * @author sunx
 * @date 2021/10/12
 */
public interface ProductIntroductionService {

  /**
   * 获取对应商品编码的介绍信息
   *
   * @param productCodeList
   * @return
   */
  List<ProductIntroduction> findByProductCodes(List<String> productCodeList);

  /**
   * 保存商品介绍信息
   *
   * @param productIntroduction
   * @param productCode
   */
  void saveIntroduction(ProductIntroduction productIntroduction, String productCode);
}
