package com.biz.crm.mdm.business.product.local.service.internal;

import com.biz.crm.mdm.business.product.local.entity.ProductIntroduction;
import com.biz.crm.mdm.business.product.local.repository.ProductIntroductionRepository;
import com.biz.crm.mdm.business.product.local.service.ProductIntroductionService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 商品富文本信息
 *
 * @author sunx
 * @date 2021/10/14
 */
@Service("productIntroductionService")
public class ProductIntroductionServiceImpl implements ProductIntroductionService {

  @Autowired(required = false) private ProductIntroductionRepository productIntroductionRepository;

  @Override
  public List<ProductIntroduction> findByProductCodes(List<String> productCodeList) {
    if (CollectionUtils.isEmpty(productCodeList)) {
      return Lists.newLinkedList();
    }
    return productIntroductionRepository.findByProductCodes(productCodeList);
  }

  @Override
  @Transactional
  public void saveIntroduction(ProductIntroduction productIntroduction, String productCode) {
    Validate.notBlank(productCode, "商品编码不能为空");
    productIntroductionRepository.deleteByProductCode(productCode);
    if (Objects.isNull(productIntroduction)) {
      return;
    }
    Validate.isTrue(productCode.equals(productIntroduction.getProductCode()), "商品编码不匹配");
    productIntroduction.setTenantCode(TenantUtils.getTenantCode());
    productIntroduction.setId(null);
    productIntroductionRepository.save(productIntroduction);
  }
}
