/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.local.service.internal;

import com.biz.crm.mdm.business.product.local.entity.ProductIntroduction;
import com.biz.crm.mdm.business.product.local.repository.ProductIntroductionRepository;
import com.biz.crm.mdm.business.product.local.service.ProductIntroductionService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="productIntroductionService")
public class ProductIntroductionServiceImpl
implements ProductIntroductionService {
    @Autowired(required=false)
    private ProductIntroductionRepository productIntroductionRepository;

    @Override
    public List<ProductIntroduction> findByProductCodes(List<String> productCodeList) {
        if (CollectionUtils.isEmpty(productCodeList)) {
            return Lists.newLinkedList();
        }
        return this.productIntroductionRepository.findByProductCodes(productCodeList);
    }

    @Override
    @Transactional
    public void saveIntroduction(ProductIntroduction productIntroduction, String productCode) {
        Validate.notBlank((CharSequence)productCode, (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productIntroductionRepository.deleteByProductCode(productCode);
        if (Objects.isNull((Object)productIntroduction)) {
            return;
        }
        Validate.isTrue((boolean)productCode.equals(productIntroduction.getProductCode()), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u5339\u914d", (Object[])new Object[0]);
        productIntroduction.setTenantCode(TenantUtils.getTenantCode());
        productIntroduction.setId(null);
        this.productIntroductionRepository.save((Object)productIntroduction);
    }
}

