/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.local.service.internal;

import com.biz.crm.mdm.business.product.local.entity.ProductMedia;
import com.biz.crm.mdm.business.product.local.repository.ProductMediaRepository;
import com.biz.crm.mdm.business.product.local.service.ProductMediaService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="productMediaService")
public class ProductMediaServiceImpl
implements ProductMediaService {
    @Autowired(required=false)
    private ProductMediaRepository productMediaRepository;

    @Override
    public List<ProductMedia> findByProductCodes(List<String> productCodeList) {
        if (CollectionUtils.isEmpty(productCodeList)) {
            return Lists.newLinkedList();
        }
        return this.productMediaRepository.findByProductCodes(productCodeList);
    }

    @Override
    @Transactional
    public void saveBatch(List<ProductMedia> productMediaList, String productCode) {
        Validate.notBlank((CharSequence)productCode, (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productMediaRepository.deleteByProductCodes(Lists.newArrayList((Object[])new String[]{productCode}));
        if (CollectionUtils.isEmpty(productMediaList)) {
            return;
        }
        Optional<ProductMedia> first = productMediaList.stream().filter(a -> StringUtils.isBlank((CharSequence)a.getProductCode()) || StringUtils.isBlank((CharSequence)a.getFileCode()) || !productCode.equals(a.getProductCode())).findFirst();
        Validate.isTrue((!first.isPresent() ? 1 : 0) != 0, (String)"\u5546\u54c1\u7f16\u7801\u6216\u5a92\u4f53\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u5fc5\u987b\u5c5e\u4e8e\u540c\u4e00\u5546\u54c1", (Object[])new Object[0]);
        for (ProductMedia productMedia : productMediaList) {
            productMedia.setId(null);
            productMedia.setTenantCode(TenantUtils.getTenantCode());
        }
        this.productMediaRepository.saveBatch(productMediaList);
    }
}

