package com.biz.crm.mdm.business.product.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.sdk.service.ProductMediaVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductMediaVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 商品附件表(ProductMedia)表控制层
 *
 * @author pengxi
 * @date 2022-09-16 22:30:37
 */
@Slf4j
@Api(tags = "商品附件: ProductMediaVo: 商品附件")
@RestController
@RequestMapping(value = {"/v1/productMedia/productMedia"})
public class ProductMediaVoController {

  @Autowired(required = false)
  private ProductMediaVoService productMediaVoService;

  /**
   * 根据商品编码集合获取对应的媒体信息
   *
   * @param productCodeList 商品编码集合
   */
  @ApiOperation(value = "根据商品编码集合获取对应的媒体信息")
  @GetMapping(value = {"/findByProductCodes"})
  public Result<List<ProductMediaVo>> findByProductCodes(@RequestParam("productCodeList") List<String> productCodeList) {
    try {
      List<ProductMediaVo> productMediaVoList = this.productMediaVoService.findByProductCodes(productCodeList);
      return Result.ok(productMediaVoList);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
