package com.biz.crm.mdm.business.product.local.deprecated.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.deprecated.model.PageResult;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.local.entity.Product;
import com.biz.crm.mdm.business.product.local.service.ProductService;
import com.biz.crm.mdm.business.product.sdk.deprecated.dto.MdmProductReqVo;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductPaginationDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 旧接口 MDM-商品管理
 *
 * @author sunx
 * @date 2021/10/14
 */
@Slf4j
@RestController
@RequestMapping("/mdmProductController")
@Api(tags = "MDM-商品管理")
@Deprecated
public class MdmProductController {

  @Autowired(required = false)
  private ProductService productService;

  @Autowired(required = false)
  private ProductVoService productVoService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @ApiOperation(value = "分页查询列表")
  @PostMapping("/pageList")
  public Result<PageResult<Product>> pageList(@RequestBody MdmProductReqVo vo) {
    try {
      vo = Optional.ofNullable(vo).orElse(new MdmProductReqVo());
      ProductPaginationDto dto =
          nebulaToolkitService.copyObjectByWhiteList(
              vo, ProductPaginationDto.class, HashSet.class, ArrayList.class);
      Page<Product> page =
          productService.findByConditions(PageRequest.of(vo.getPageNum(), vo.getPageSize()), dto);
      PageResult<Product> pageResult =
          PageResult.<Product>builder().data(page.getRecords()).count(page.getTotal()).build();
      return Result.ok(pageResult);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "详情", httpMethod = "GET")
  @ApiImplicitParams({
    @ApiImplicitParam(
        name = "id",
        value = "ID",
        required = false,
        dataType = "String",
        paramType = "query"),
    @ApiImplicitParam(
        name = "productCode",
        value = "商品编码",
        required = false,
        dataType = "String",
        paramType = "query")
  })
  @GetMapping("/detail")
  public Result<ProductVo> detail(
      @RequestParam(value = "id", required = false) String id,
      @RequestParam(value = "productCode", required = false) String productCode) {
    List<String> ids = Lists.newLinkedList();
    List<String> productCodes = Lists.newLinkedList();
    if (StringUtils.isNotBlank(id)) {
      ids.add(id);
    }
    if (StringUtils.isNotBlank(productCode)) {
      productCodes.add(productCode);
    }
    try {
      ProductVo vo = null;
      List<ProductVo> list = productVoService.findDetailsByIdsOrProductCodes(ids, productCodes);
      if (CollectionUtils.isNotEmpty(list)) {
        vo = list.stream().findFirst().orElse(null);
      }
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "新增")
  @PostMapping("/save")
  public Result<?> save(@RequestBody ProductDto dto) {
    try {
      productVoService.create(dto);
      return Result.ok("新增成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新")
  @PostMapping("/update")
  public Result<?> update(@RequestBody ProductDto dto) {
    try {
      productVoService.update(dto);
      return Result.ok("修改成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "删除", httpMethod = "POST")
  @ApiImplicitParams({
    @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/delete")
  public Result<?> delete(@RequestBody List<String> ids) {
    try {
      productService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "上架", httpMethod = "POST")
  @ApiImplicitParams({
    @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/upShelf")
  public Result<?> upShelf(@RequestBody List<String> ids) {
    try {
      productService.upShelf(ids);
      return Result.ok("上架成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "下架", httpMethod = "POST")
  @ApiImplicitParams({
    @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/downShelf")
  public Result<?> downShelf(@RequestBody List<String> ids) {
    try {
      productService.downShelf(ids);
      return Result.ok("下架成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
