package com.biz.crm.mdm.business.product.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.product.local.entity.Product;
import com.biz.crm.mdm.business.product.sdk.dto.ContractProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductPaginationDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.annotations.Param;

/**
 * mdm_product 商品主数据(Product)表数据库访问层
 *
 * @author sunx
 * @since 2021-10-13 15:38:54
 */
public interface ProductMapper extends BaseMapper<Product> {

  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto 分页参数dto
   * @return 分页列表
   */
  Page<Product> findByConditions(Page<Product> page, @Param("dto") ProductPaginationDto dto);

  /**
   * 根据商品层级获取对应的商品信息
   *
   * @param productLevelCodeList
   * @param tenantCode
   * @param delFlag  删除标记
   * @return
   */
  List<ProductVo> findByProductLevelCodes(
      @Param("list") List<String> productLevelCodeList, @Param("tenantCode") String tenantCode,@Param("delFlag")String delFlag);

  /**
   * 获取商品对应的层级编码集合
   *
   * @param productCodeSet
   * @param tenantCode
   * @return
   */
  Set<String> findProductLevelCodeSetByProductCodes(@Param("list") Set<String> productCodeSet, @Param("tenantCode") String tenantCode);

  /**
   * 根据ProductQueryDto获取商品主信息
   *
   * @param dto
   * @return
   */
  List<Product> findByProductQueryDto(@Param("dto") ProductQueryDto dto);

  /**
   * 获取合同配置可购清单商品数据(商品编码+名称)
   *
   * @param dto
   * @param tenantCode
   * @param delFlag
   * @param enableStatus
   * @param shelfFlag
   * @return
   */
  List<Product> findByContractProductQueryDto(
      @Param("dto") ContractProductQueryDto dto,
      @Param("tenantCode") String tenantCode,
      @Param("delFlag") String delFlag,
      @Param("enableStatus") String enableStatus,
      @Param("shelfFlag") String shelfFlag);
}
