package com.biz.crm.mdm.business.product.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.mdm.business.product.local.entity.ProductMaterial;
import java.util.Set;
import org.apache.ibatis.annotations.Param;

/**
 * 商品物料表(ProductMaterial)表数据库访问层
 *
 * @author sunx
 * @since 2021-10-14 16:06:46
 */
public interface ProductMaterialMapper extends BaseMapper<ProductMaterial> {

  /**
   * 获取物料关联的商品编码集合
   *
   * @param materialCode
   * @param tenantCode
   * @param enableStatus
   * @param delFlag
   * @return
   */
  Set<String> findProductCodeByMaterialCode(
      @Param("materialCode") String materialCode,
      @Param("tenantCode") String tenantCode,
      @Param("enableStatus") String enableStatus,
      @Param("delFlag") String delFlag);
}
