package com.biz.crm.mdm.business.product.local.service;

import com.biz.crm.mdm.business.product.local.entity.ProductMaterial;
import java.util.List;
import java.util.Set;

/**
 * 商品物料关系
 *
 * @author sunx
 * @date 2021/10/12
 */
public interface ProductMaterialService {

  /**
   * 根据编码获取对应物料信息
   *
   * @param productCodeList
   * @return
   */
  List<ProductMaterial> findByProductCodes(List<String> productCodeList);

  /**
   * 保存商品关联的物料信息
   *
   * @param productMaterialList
   * @param productCode
   */
  void saveBatch(List<ProductMaterial> productMaterialList, String productCode);

  /**
   * 根据物料编码获取匹配的数量
   *
   * @param materialCodes
   * @return
   */
  Integer countByMaterialCodes(List<String> materialCodes);

  /**
   * 获取物料关联的商品编码集合
   *
   * @param materialCode
   * @return
   */
  Set<String> findProductCodeByMaterialCode(String materialCode);

  /**
   * 新增物料信息
   *
   * @param productMaterial
   */
  void create(ProductMaterial productMaterial);
}
