package com.biz.crm.mdm.business.product.local.service.internal;

import com.biz.crm.mdm.business.product.local.entity.ProductMedia;
import com.biz.crm.mdm.business.product.local.repository.ProductMediaRepository;
import com.biz.crm.mdm.business.product.sdk.service.ProductMediaVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductMediaVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * 商品媒体信息
 *
 * @author pengxi
 * @date 2022-09-16 22:30:37
 */
@Service
public class ProductMediaVoServiceImpl implements ProductMediaVoService {

  @Autowired(required = false) private ProductMediaRepository productMediaRepository;

  @Autowired(required = false) @Qualifier("nebulaToolkitService") private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<ProductMediaVo> findByProductCodes(List<String> productCodeList) {
    if (CollectionUtils.isEmpty(productCodeList)) {
      return Lists.newLinkedList();
    }
    List<ProductMedia> productMediaList = this.productMediaRepository.findByProductCodes(productCodeList);
    if (CollectionUtils.isEmpty(productMediaList)) {
      return Lists.newLinkedList();
    }
    return (List<ProductMediaVo>) this.nebulaToolkitService.copyCollectionByBlankList(
            productMediaList, ProductMedia.class, ProductMediaVo.class, HashSet.class, ArrayList.class);
  }

}
