/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.local.service.notifier;

import com.biz.crm.mdm.business.material.sdk.event.MaterialEventListener;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialEventVo;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.biz.crm.mdm.business.product.local.service.ProductMaterialService;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MaterialEventListenerImpl
implements MaterialEventListener {
    @Autowired(required=false)
    private ProductMaterialService productMaterialService;

    public void onDelete(MaterialEventVo materialEventVo) {
        List materialVos = materialEventVo.getMaterialVos();
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)materialVos), (String)"\u89e6\u53d1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> materialCodes = materialVos.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getMaterialCode())).map(MaterialVo::getMaterialCode).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(materialCodes), (String)"\u7269\u6599\u7f16\u7801\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Integer count = this.productMaterialService.countByMaterialCodes(materialCodes);
        count = Optional.ofNullable(count).orElse(0);
        Validate.isTrue((count.compareTo(0) <= 0 ? 1 : 0) != 0, (String)"\u5b58\u5728\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f,\u65e0\u6cd5\u6267\u884c\u5220\u9664", (Object[])new Object[0]);
    }

    public void onEnable(MaterialEventVo materialEventVo) {
    }

    public void onDisable(MaterialEventVo materialEventVo) {
    }

    public void onChange(MaterialEventVo materialEventVo) {
    }

    public void onCreate(MaterialEventVo materialEventVo) {
    }
}

