/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.local.service.notifier;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.product.level.sdk.event.ProductLevelEventListener;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.local.service.ProductService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductLevelEventListenerImpl
implements ProductLevelEventListener {
    @Autowired(required=false)
    private ProductService productService;

    public void onBatchCreate(List<ProductLevelVo> productLevelVos) {
    }

    public void onBatchUpdate(List<ProductLevelVo> productLevelVos) {
    }

    public void onBatchDelete(List<ProductLevelVo> productLevelVos) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(productLevelVos), (String)"\u89e6\u53d1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> productLevelCodes = productLevelVos.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductLevelCode())).map(ProductLevelVo::getProductLevelCode).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(productLevelCodes), (String)"\u5546\u54c1\u5c42\u7ea7\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Integer count = this.productService.countByProductLevelCodesAndDelFlag(productLevelCodes, DelFlagStatusEnum.NORMAL.getCode());
        count = Optional.ofNullable(count).orElse(0);
        Validate.isTrue((count.compareTo(0) <= 0 ? 1 : 0) != 0, (String)"\u5b58\u5728\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f", (Object[])new Object[0]);
    }

    public void onBatchEnable(List<ProductLevelVo> productLevelVos) {
    }

    public void onBatchDisable(List<ProductLevelVo> productLevelVos) {
    }
}

