package com.biz.crm.mdm.business.product.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商品图片视频表dto
 *
 * @author sunx
 * @since 2021-10-13 17:27:07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "商品图片视频表dto")
public class ProductMediaDto extends TenantDto {

  @ApiModelProperty("商品编码")
  private String productCode;

  @ApiModelProperty("图片地址")
  private String urlAddress;

  @ApiModelProperty("文件类型('picture'图片,'video'视频)")
  private String type;

  @ApiModelProperty("文件名")
  private String fileName;

  @ApiModelProperty("原始文件名")
  private String originalFileName;

  @ApiModelProperty("文件路径")
  private String relativeLocal;

  @ApiModelProperty("OSS文件对象名")
  private String objectName;
}
