package com.biz.crm.mdm.business.product.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;
import java.util.Set;

/**
 * mdm_product 商品主数据分页查询dto
 *
 * @author sunx
 * @since 2021-10-13 17:11:24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductPaginationDto", description = "mdm_product 商品主数据分页查询dto")
public class ProductPaginationDto extends TenantFlagOpDto {

  /** 商品层级编码 */
  @ApiModelProperty("商品层级编码")
  private String productLevelCode;

  /** 商品编码 */
  @ApiModelProperty("商品编码")
  private String productCode;

  /** 商品名称 */
  @ApiModelProperty("商品名称")
  private String productName;

  /** 上下加状态 */
  @ApiModelProperty("上下加状态")
  private String isShelf;

  /** 编码名称模糊查询 */
  @ApiModelProperty("编码名称模糊查询")
  private String keyword;

  /**
   * 用于下拉列表选择,输入回显编码集合，字符串集合，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据
   */
  @ApiModelProperty("用于下拉列表选择,输入回显编码集合，字符串集合，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
  private List<String> selectedCode;

  /**
   * 用于商品层级编码集合查询
   */
  @ApiModelProperty("商品层级编码集合")
  private Set<String> productLevelCodes;

  /**
   * 用于商品编码集合查询
   */
  @ApiModelProperty("商品编码集合")
  private Set<String> productCodes;
}
