package com.biz.crm.mdm.business.product.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Set;
import lombok.Data;

/**
 * 合同可购清单商品信息查询dto
 *
 * @author sunx
 * @date 2022/7/8
 */
@Data
@ApiModel(value = "ContractProductQueryDto", description = "合同可购清单商品信息查询dto")
public class ContractProductQueryDto {
  /** 商品编码集合 */
  @ApiModelProperty(value = "商品编码集合")
  private Set<String> productCodeSet;
  /** 商品层级编码集合 */
  @ApiModelProperty(value = "商品层级编码集合")
  private Set<String> productLevelCodeSet;
  /** 是否需要union查询 */
  @ApiModelProperty(value = "是否需要union查询",hidden = true)
  private Boolean unionType;
}
