package com.biz.crm.mdm.business.product.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "同步商品主信息dto")
public class ProductSynchronousUpdateDto extends TenantFlagOpDto {

  @ApiModelProperty("助记码")
  private String mnemonicMark;

  @ApiModelProperty("商品简称")
  private String productShortName;
  /**
   * 附件信息
   */
  @ApiModelProperty("附件信息，图片信息")
  private List<ProductMediaDto> pictureMediaList;

  @ApiModelProperty("单位信息")
  private List<ProductUnitDto> unitList;

  /**
   * 附件信息
   */
  @ApiModelProperty("附件信息，视频信息")
  private List<ProductMediaDto> videoMediaList;
  /**
   * 商品介绍
   */
  @ApiModelProperty("商品介绍-富文本")
  private ProductIntroductionDto introduction;
}
