package com.biz.crm.mdm.business.product.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * 商品单位dto
 *
 * @author sunx
 * @since 2021-10-13 17:26:22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "商品单位dto")
public class ProductUnitDto extends TenantDto {

  @ApiModelProperty("商品编码")
  private String productCode;

  @ApiModelProperty("单位类型,数据字典[product_unit_type]")
  private String unitType;

  @ApiModelProperty("单位编码")
  private String unitCode;

  @ApiModelProperty("单位名称")
  private String unitName;

  @ApiModelProperty("转换系数,基本单位为1")
  private Integer transScale;

  @ApiModelProperty("单位级别")
  private String unitLevel;

  @ApiModelProperty("条形码")
  private String Barcode;

  @ApiModelProperty("建议销售价")
  private String recommendedSalesPrice;

  @ApiModelProperty("建议进货价")
  private String recommendedRestockingPrice;
}
