package com.biz.crm.mdm.business.product.sdk.event;

import com.biz.crm.mdm.business.product.sdk.dto.ProductEventDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductSingleEventDto;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * mdm_product 商品主数据dto
 *
 * @author sunx
 * @since 2021-10-13 17:11:30
 */
public interface ProductEventListener extends NebulaEvent {

  /**
   * 创建事件
   *
   * @param productEventDto
   */
  default void onCreate(ProductEventDto productEventDto) {}

  /**
   * 当物料创建时触发
   *
   * @param vo 创建时的vo
   */
  void onCreateMaterial(ProductVo vo);

  /**
   * 当职位创建时触发
   *
   * @param vo 创建时的vo
   */

  /**
   * 编辑事件
   *
   * @param productEventDto
   */
  default void onUpdate(ProductEventDto productEventDto) {}

  /**
   * 删除事件
   *
   * @param productEventDto
   */
  default void onDelete(ProductEventDto productEventDto) {}

  /**
   * 启用事件
   *
   * @param productSingleEventDto
   */
  default void onEnable(ProductSingleEventDto productSingleEventDto) {}

  /**
   * 禁用事件
   *
   * @param productSingleEventDto
   */
  default void onDisable(ProductSingleEventDto productSingleEventDto) {}

  /**
   * 上架事件
   *
   * @param productSingleEventDto
   */
  default void onUpShelf(ProductSingleEventDto productSingleEventDto) {}

  /**
   * 下架事件
   *
   * @param productSingleEventDto
   */
  default void onDownShelf(ProductSingleEventDto productSingleEventDto) {}
}
