package com.biz.crm.mdm.business.product.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.product.sdk.dto.*;
import com.biz.crm.mdm.business.product.sdk.vo.DisplayProductVo;
import com.biz.crm.mdm.business.product.sdk.vo.MaterialProductVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductPlanningDetailsVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 商品主数据Vo接口
 *
 * @author sunx
 * @since 2021-10-13 17:36:03
 */
public interface ProductVoService {

  /**
   * 创建
   *
   * @param dto
   * @return
   */
  default ProductVo create(ProductDto dto) {
    return null;
  }

  /**
   * 更新
   *
   * @param dto
   * @return
   */
  default ProductVo update(ProductDto dto) {
    return null;
  }

  /**
   * 可选商品下拉
   *
   * @param keyword
   * @return
   */
  default List<ProductVo> findSelectByKeyword(String keyword) {
    return Lists.newLinkedList();
  }

  /**
   * 获取物料对应的关联商品编码集合，及商品对应层级及其上级层级编码集合
   *
   * @param materialCode
   * @return
   */
  default MaterialProductVo findMaterialProductVoByMaterialCode(String materialCode) {
    return null;
  }

  /**
   * 根据商品层级获取对应的商品的主信息
   *
   * @param productLevelCodeList
   * @return
   */
  default List<ProductVo> findByProductLevelCodes(List<String> productLevelCodeList) {
    return Lists.newLinkedList();
  }

  /**
   * 获取商品对应层级及其上级层级编码集合
   *
   * @param productCodeSet
   * @return
   */
  default Set<String> findParentLevelCodeSetByProductCodes(Set<String> productCodeSet) {
    return Sets.newHashSet();
  }

  /**
   * 根据ProductQueryDto获取商品主信息
   *
   * @param dto
   * @return
   */
  default List<ProductVo> findByProductQueryDto(ProductQueryDto dto) {
    return Lists.newLinkedList();
  }

  /**
   * 根据ProductQueryDto获取商品主信息
   *
   * @param dto
   * @return
   */
  default List<ProductVo> findByQueryDto(ProductQueryDto dto) {
    return Lists.newLinkedList();
  }

  /**
   * 根据id或编码集合获取商品详情集合
   *
   * @param ids
   * @param productCodes
   * @return
   */
  default List<ProductVo> findDetailsByIdsOrProductCodes(
          List<String> ids, List<String> productCodes) {
    return Lists.newLinkedList();
  }

  /**
   * 根据id集合获取商品详情集合
   *
   * @param ids
   * @return
   */
  default List<ProductVo> findDetailsByIds(List<String> ids) {
    return Lists.newLinkedList();
  }

  /**
   * 根据编码集合获取商品详情集合
   *
   * @param productCodes
   * @return
   */
  default List<ProductVo> findDetailsByProductCodes(List<String> productCodes) {
    return Lists.newLinkedList();
  }

  /**
   * 根据产品编码集合批量查询
   *
   * @param codes
   * @return java.util.List<com.biz.crm.mdm.business.product.sdk.vo.ProductVo>
   * @author huojia
   * @date 2023/1/18 19:01
   **/
  List<ProductVo> findByCodes(List<String> codes);

  /**
   * 根据商品编码集合获取商品集合
   *
   * @param productCodes
   * @return
   */
  default List<ProductVo> findByProductCodes(List<String> productCodes) {
    return Lists.newLinkedList();
  }

  /**
   * 根据商品商品编码集合获取商品主信息+层级信息
   *
   * @param productCodeList
   * @return
   */
  default List<ProductVo> findMainDetailsByProductCodes(List<String> productCodeList) {
    return Lists.newLinkedList();
  }

  /**
   * 根据ProductDetailQueryDto获取商品详情信息
   *
   * @param dto
   * @return
   */
  default List<ProductVo> findDetailsByProductDetailQueryDto(ProductDetailQueryDto dto) {
    return Lists.newLinkedList();
  }

  /**
   * 根据层级获取层级及下级所有的上架且启用的产品集合
   *
   * @param productLevelCodes
   * @return k-产品编码，v-关联层级对应的降维码集合
   */
  default Map<String, String> findAllowSaleProductByProductLevelCodes(Set<String> productLevelCodes) {
    return Maps.newHashMap();
  }

  /**
   * 根据ProductPaginationDto获取商品分页信息
   *
   * @param pageable 分页参数
   * @param dto      查询对象
   * @return Page<ProductVo>
   */
  default Page<ProductVo> findByConditions(Pageable pageable, ProductPaginationDto dto) {
    return new Page<>(pageable.getPageNumber(), pageable.getPageSize());
  }

  /**
   * 条件查询
   *
   * @param dto
   * @return java.util.List<com.biz.crm.mdm.business.product.sdk.vo.ProductVo>
   * @author huojia
   * @date 2022/12/2 17:17
   **/
  List<ProductVo> queryCondition(ProductDto dto);

  /**
   * 根据产品编码查询数据
   *
   * @param unitTypeCode
   * @return java.util.List<com.biz.crm.mdm.business.product.sdk.vo.ProductVo>
   * @author huojia
   * @date 2022/12/2 17:17
   **/
  ProductVo finByUnitTypeCode(String unitTypeCode);

  /**
   * 根据商品编码集合获取对应的商品数据信息
   *
   * @param productCode 商品编码
   */
  ProductPlanningDetailsVo findByProductPlanningDetails(String productCode, String customerCode, String businessModel, String startDate);

  /**
   * 根据商品编码集合获取商品集合
   *
   * @return List<String>
   */
  List<String> findAllProductCode();

  /**
   * 根据商品编码集合获取商品集合
   *
   * @return Map<String, String>
   */
  Map<String, String> getProductByCodes(List<List<String>> codes);

  /**
   * 根据商品编码查询商品名称
   *
   * @param ids
   * @param productCodes
   * @return
   */
  default Map<String, String> findNameByIdsOrCodes(List<String> ids, List<String> productCodes) {
    return Maps.newHashMap();
  }

  /**
   * 同步产品编辑
   *
   * @param dto
   * @return
   */
  ProductVo updateSynchronous(ProductSynchronousUpdateDto dto);

  /**
   * 根据业务type查询物料包或者品牌组或者品类名称
   *
   * @param displayProductDto
   * @return
   */
  List<DisplayProductVo> findPackageDescOrBrandOrgOrCategory(DisplayProductDto displayProductDto);

  /**
   * 单个编码查询
   *
   * @param productCode
   * @param enableStatusFlag
   * @return {@link ProductVo}
   */
  default ProductVo findByCode(String productCode, Boolean enableStatusFlag) {
    return null;
  }

  /**
   * <p>
   * 集合A: 集合A中的每个对象，都包括
   * 商品编号productCode
   * 商品单位productUnit
   * 集合B: 这个集合中的每一个对象信息都包括：
   * 商品分组编号productGroupCode
   * 商品分组中可能包括的单位信息：productUnits
   * <p>
   * 判断两个集合是否存在商品信息交集。
   *
   * @param productCodeUnitGroups   集合A
   * @param productLevelUnitsGroups 集合B
   * @return {@link ProductVo}
   */
  default Boolean validProductGroupUnion(List<ProductCodeUnitGroup> productCodeUnitGroups,
                                         List<ProductLevelUnitsGroup> productLevelUnitsGroups) {
    return false;
  }
}
