package com.biz.crm.mdm.business.product.sdk.vo;

import java.math.BigDecimal;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 *
 * 产品策划通过产品编码查询商品数据
 *
 * @author sunx
 * @since 2021-10-13 17:27:07
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "产品策划通过产品编码查询商品数据Vo")
public class ProductPlanningDetailsVo extends TenantFlagOpVo {

    /** 商品编码 */
    @ApiModelProperty("商品编码")
    private String productCode;

    /** 商品名称 */
    @ApiModelProperty("商品名称")
    private String productName;

    /** 产品品牌名称 */
    @ApiModelProperty("产品品牌名称")
    private String productBrandName;

    /** 产品品牌名称 */
    @ApiModelProperty("产品品牌名称")
    private String productBrandCode;

    /** 税率 */
    @ApiModelProperty("税率")
    private BigDecimal rate;

    /** 价格换算系数 */
//    @ApiModelProperty("价格换算系数")
//    private BigDecimal priceConversion;

    /** 建议零售价 */
//    @ApiModelProperty("建议零售价")
//    private BigDecimal price;

    /** 标准零售价 */
    @ApiModelProperty("标准零售价")
    private BigDecimal standardRetailPrice;

    /** 平台供货价 */
    @ApiModelProperty("平台供货价")
    private BigDecimal platformSupplyPrice;

    /** 红线价 */
    @ApiModelProperty("红线价")
    private BigDecimal redLinePrice;

    /** 成本价 */
    @ApiModelProperty("成本价")
    private BigDecimal costPrice;

    public ProductPlanningDetailsVo(String productCode, String productName, String productBrandName, String productBrandCode, BigDecimal rate) {
        this.productCode = productCode;
        this.productName = productName;
        this.productBrandName = productBrandName;
        this.productBrandCode = productBrandCode;
        this.rate = rate;
    }
}
