package com.biz.crm.mdm.business.product.sdk.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.biz.crm.mdm.business.product.sdk.dto.ProductUnitDto;
import org.springframework.format.annotation.DateTimeFormat;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * mdm_product 商品主数据vo
 *
 * @author sunx
 * @since 2021-10-13 17:24:35
 */
@Getter
@Setter
@ApiModel(value = "商品主信息Vo")
public class ProductVo extends TenantFlagOpVo {
  private static final long serialVersionUID = -4123816584206260462L;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;

  @ApiModelProperty("商品简称")
  private String productShortName;

  @ApiModelProperty("助记码")
  private String mnemonicMark;

  @ApiModelProperty("产品品牌编码")
  private String productBrandCode;

  @ApiModelProperty("产品品牌名称")
  private String productBrandName;

  @ApiModelProperty("产品品类编码")
  private String productCategoryCode;

  @ApiModelProperty("产品品类名称")
  private String productCategoryName;

  @ApiModelProperty("产品层级编码（品相编码）")
  private String productLevelCode;

  @ApiModelProperty("产品层级名称（品相名称）")
  private String productLevelName;

  @ApiModelProperty("保质期")
  private Integer expirationDate;

  @ApiModelProperty("品牌组")
  private String brandOrg;
  @ApiModelProperty("税码")
  private String taxCode;

  @ApiModelProperty("税率")
  private BigDecimal rate;

  @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
  private String businessFormatCode;

  @ApiModelProperty("所属销售机构编码")
  private String salesInstitutionCode;

  @ApiModelProperty("所属销售机构")
  private String salesInstitutionName;

  /**
   * 商品类型
   */
  @ApiModelProperty("商品类型")
  private String productType;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  private String saleUnit;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  private String spec;

  /**
   * 基本单位
   */
  @ApiModelProperty("基本单位")
  private String baseUnit;

  /**
   * 净重
   */
  @ApiModelProperty("净重")
  private BigDecimal netWeight;

  /**
   * 开始时间
   */
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("开始时间")
  private Date beginDateTime;

  /**
   * 结束时间
   */
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("结束时间")
  private Date endDateTime;

  /**
   * 上下架状态
   */
  @ApiModelProperty("上下架状态")
  private String isShelf;

  /**
   * 条形码
   */
  @ApiModelProperty("条形码")
  private String barCode;

  /**
   * 是否维护图片
   */
  @ApiModelProperty("是否维护图片")
  private Boolean maintenancePicture;

  /**
   * 是否维护详情
   */
  @ApiModelProperty("是否维护详情")
  private Boolean maintenanceIntroduction;

  /**
   * 销售公司
   */
  @ApiModelProperty("销售公司")
  private String saleCompany;

  /**
   * sfa图片地址
   */
  @ApiModelProperty("sfa图片地址")
  private String picUrl;

  /**
   * 主图片url
   */
  @ApiModelProperty("主图片url")
  private String primaryPictureUrl;


  @ApiModelProperty("商品组")
  private String productOrg;

  @ApiModelProperty("商品组描述")
  private String productOrgDesc;

  @ApiModelProperty("商品组入数")
  private String productIncoming;


  @ApiModelProperty("重量单位")
  private String unitWeight;

  @ApiModelProperty("体积单位")
  private String volumeWeight;

  @ApiModelProperty("小包装容量")
  private String packageQuantityMin;

  @ApiModelProperty("小包装容量单位")
  private String packageQuantityMinUnite;


  @ApiModelProperty("包装物料")
  private String packageProduct;

  @ApiModelProperty("包装描述")
  private String packageDesc;

  @ApiModelProperty("财务管理报告品牌")
  private String packageReport;

  @ApiModelProperty("财务管理报告品牌描述")
  private String packageReportDescDesc;

  @ApiModelProperty("产品真实属性")
  private String packageTrueProps;

  @ApiModelProperty("纸箱条码(外包)")
  private String cartonBarCode;

  @ApiModelProperty("长")
  private String forte;

  @ApiModelProperty("宽")
  private String width;

  @ApiModelProperty("高")
  private String high;

  @ApiModelProperty("基本单位描述")
  private String baseUnitDes;

  @ApiModelProperty("包装系数")
  private String packageScale;

  @ApiModelProperty("液态产品密度")
  private String liquidStateProductDensity;

  @ApiModelProperty("业务量")
  private String businessAmount;

  @ApiModelProperty("口味")
  private String taste;

  @ApiModelProperty(name = "电商品类[数据字典:mdm_category]", notes = "")
  private String onlineCategory;

  @ApiModelProperty(name = "主体分类[数据字典:mdm_zhuti_classify]", notes = "")
  private String mainCategory;

  /** 关联物料信息 */
  @ApiModelProperty("关联物料信息")
  private List<ProductMaterialVo> materialList;

  /**
   * 主图信息
   */
  @ApiModelProperty("附件信息，主图信息")
  private List<ProductMediaVo> majorPictureMedia;

  /**
   * 图片信 息
   */
  @ApiModelProperty("附件信息，图片信息")
  private List<ProductMediaVo> pictureMediaList;

  /**
   * 视频信息
   */
  @ApiModelProperty("附件信息，视频信息")
  private List<ProductMediaVo> videoMediaList;

  @ApiModelProperty("单位信息")
  private List<ProductUnitVo> unitList;

  /**
   * 商品介绍
   */
  @ApiModelProperty("商品介绍-富文本")
  private ProductIntroductionVo introduction;
}
