package com.biz.crm.mdm.business.product.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * mdm_product 商品主数据dto
 *
 * @author sunx
 * @since 2021-10-13 17:24:35
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "商品主信息dto")
public class ProductDto extends TenantFlagOpDto {

  /** 商品编码 */
  @ApiModelProperty("商品编码")
  private String productCode;
  /** 商品名称 */
  @ApiModelProperty("商品名称")
  private String productName;
  /** 产品层级编码 */
  @ApiModelProperty("产品层级编码")
  private String productLevelCode;

  /** 产品层级 */
  @ApiModelProperty("产品层级")
  private String productLevelName;
  /** 商品类型 */
  @ApiModelProperty("商品类型")
  private String productType;
  /** 销售单位 */
  @ApiModelProperty("销售单位")
  private String saleUnit;
  /** 规格 */
  @ApiModelProperty("规格")
  private String spec;
  /** 基本单位 */
  @ApiModelProperty("基本单位")
  private String baseUnit;
  /** 开始时间 */
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("开始时间")
  private Date beginDateTime;
  /** 结束时间 */
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("结束时间")
  private Date endDateTime;
  /** 上下架状态 */
  @ApiModelProperty("上下架状态")
  private String isShelf;

  /** 条形码 */
  @ApiModelProperty("条形码")
  private String barCode;
  /** 是否维护图片 */
  @ApiModelProperty("是否维护图片")
  private Boolean maintenancePicture;
  /** 是否维护详情 */
  @ApiModelProperty("是否维护详情")
  private Boolean maintenanceIntroduction;
  /** 销售公司 */
  @ApiModelProperty("销售公司")
  private String saleCompany;
  /** sfa图片地址 */
  @ApiModelProperty("sfa图片地址")
  private String picUrl;
  /** 主图片url */
  @ApiModelProperty("主图片url")
  private String primaryPictureUrl;
  /** 关联物料信息 */
  @ApiModelProperty("关联物料信息")
  private List<ProductMaterialDto> materialList;
  /** 附件信息 */
  @ApiModelProperty("附件信息，图片信息")
  private List<ProductMediaDto> pictureMediaList;
  /** 附件信息 */
  @ApiModelProperty("附件信息，视频信息")
  private List<ProductMediaDto> videoMediaList;
  /** 商品介绍 */
  @ApiModelProperty("商品介绍-富文本")
  private ProductIntroductionDto introduction;
}
