package com.biz.crm.mdm.business.product.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商品主信息查询dto
 *
 * @author sunx
 * @date 2022/4/27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "商品主信息查询dto")
public class ProductQueryDto {
  /** 商品编码 */
  @ApiModelProperty("商品编码,模糊查询")
  private String productCode;
  /** 商品名称 */
  @ApiModelProperty("商品名称,模糊查询")
  private String productName;
  /** 商品层级集合 */
  @ApiModelProperty("商品层级集合")
  private List<String> productLevelCodeList;
  /** 商品编码集合 */
  @ApiModelProperty("商品编码集合")
  private List<String> productCodeList;
  /** 上下加状态 */
  @ApiModelProperty("上下加状态")
  private String isShelf;
  /** 启用禁用状态 */
  @ApiModelProperty("启用禁用状态")
  private String enableStatus;
  /** 删除标记 */
  @ApiModelProperty("删除标记")
  private String delFlag;
  /** 租户编号 */
  @ApiModelProperty(name = "tenantCode", value = "租户编号")
  private String tenantCode;
}
