package com.biz.crm.mdm.business.product.sdk.enums;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 商品额外扩展信息类型枚举
 *
 * @author sunx
 * @date 2022/6/22
 */
@Getter
@AllArgsConstructor
public enum ProductExtInfoTypeEnum {
  /** 商品额外扩展信息类型枚举 */
  PRODUCT_LEVEL("product_level", "product_level", "商品层级", "0"),
  MATERIAL("material", "material", "物料", "1"),
  PICTURE("picture", "picture", "图片", "2"),
  VIDEO("video", "video", "视频", "3"),
  INTRO("intro", "intro", "详情", "4"),
  ;
  /** 系统key */
  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;

  /**
   * 返回所有key
   *
   * @return
   */
  public static Set<String> findAllKey() {
    return Stream.of(ProductExtInfoTypeEnum.values())
        .map(ProductExtInfoTypeEnum::getDictCode)
        .collect(Collectors.toSet());
  }
}
